"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateDatasets = generateDatasets;
var _constants = require("../../common/constants");
var _utils = require("../../common/utils");
var _data_stream_stat = require("../../common/data_streams_stats/data_stream_stat");
var _flatten_stats = require("./flatten_stats");
var _calculate_percentage = require("./calculate_percentage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function generateDatasets(dataStreamStats = [], degradedDocStats = [], failedDocStats = [], integrations, totalDocsStats) {
  const {
    datasetIntegrationMap,
    integrationsMap
  } = integrations.reduce((acc, integration) => {
    return {
      datasetIntegrationMap: {
        ...acc.datasetIntegrationMap,
        ...Object.keys(integration.datasets).reduce((datasetsAcc, dataset) => Object.assign(datasetsAcc, {
          [dataset]: {
            integration,
            title: integration.datasets[dataset]
          }
        }), {})
      },
      integrationsMap: {
        ...acc.integrationsMap,
        [integration.name]: integration
      }
    };
  }, {
    datasetIntegrationMap: {},
    integrationsMap: {}
  });
  const totalDocs = (0, _flatten_stats.flattenStats)(totalDocsStats);
  const totalDocsMap = Object.fromEntries(totalDocs.map(({
    dataset,
    count
  }) => [dataset, count]));
  const failedMap = failedDocStats.reduce((failedMapAcc, {
    dataset,
    count
  }) => {
    var _totalDocsMap$dataset;
    return Object.assign(failedMapAcc, {
      [dataset]: {
        count,
        percentage: (0, _calculate_percentage.calculatePercentage)({
          totalDocs: ((_totalDocsMap$dataset = totalDocsMap[dataset]) !== null && _totalDocsMap$dataset !== void 0 ? _totalDocsMap$dataset : 0) + count,
          count
        })
      }
    });
  }, {});
  const degradedMap = degradedDocStats.reduce((degradedMapAcc, {
    dataset,
    count
  }) => {
    var _totalDocsMap$dataset2, _failedMap$dataset$co, _failedMap$dataset;
    return Object.assign(degradedMapAcc, {
      [dataset]: {
        count,
        percentage: (0, _calculate_percentage.calculatePercentage)({
          totalDocs: ((_totalDocsMap$dataset2 = totalDocsMap[dataset]) !== null && _totalDocsMap$dataset2 !== void 0 ? _totalDocsMap$dataset2 : 0) + ((_failedMap$dataset$co = (_failedMap$dataset = failedMap[dataset]) === null || _failedMap$dataset === void 0 ? void 0 : _failedMap$dataset.count) !== null && _failedMap$dataset$co !== void 0 ? _failedMap$dataset$co : 0),
          count
        })
      }
    });
  }, {});
  if (!dataStreamStats.length) {
    // We want to pick up all datasets even when they don't have degraded docs or failed docs
    const dataStreams = [...new Set([...Object.keys(totalDocsMap), ...Object.keys(degradedMap), ...Object.keys(failedMap)])];
    return dataStreams.map(dataset => {
      var _totalDocsMap$dataset3, _failedMap$dataset$co2, _failedMap$dataset2;
      return _data_stream_stat.DataStreamStat.fromQualityStats({
        datasetName: dataset,
        degradedDocStat: degradedMap[dataset] || _constants.DEFAULT_QUALITY_DOC_STATS,
        failedDocStat: failedMap[dataset] || _constants.DEFAULT_QUALITY_DOC_STATS,
        datasetIntegrationMap,
        totalDocs: ((_totalDocsMap$dataset3 = totalDocsMap[dataset]) !== null && _totalDocsMap$dataset3 !== void 0 ? _totalDocsMap$dataset3 : 0) + ((_failedMap$dataset$co2 = (_failedMap$dataset2 = failedMap[dataset]) === null || _failedMap$dataset2 === void 0 ? void 0 : _failedMap$dataset2.count) !== null && _failedMap$dataset$co2 !== void 0 ? _failedMap$dataset$co2 : 0)
      });
    });
  }
  return dataStreamStats === null || dataStreamStats === void 0 ? void 0 : dataStreamStats.map(dataStream => {
    var _datasetIntegrationMa, _datasetIntegrationMa2, _datasetIntegrationMa3, _dataStream$integrati, _totalDocsMap$dataset4, _failedMap$dataset$ra, _failedMap$dataset$ra2;
    const dataset = _data_stream_stat.DataStreamStat.create(dataStream);
    const degradedDocs = degradedMap[dataset.rawName] || dataset.degradedDocs;
    const failedDocs = failedMap[dataset.rawName] || dataset.failedDocs;
    const qualityStats = [degradedDocs.percentage, failedDocs.percentage];
    return {
      ...dataset,
      title: ((_datasetIntegrationMa = datasetIntegrationMap[dataset.name]) === null || _datasetIntegrationMa === void 0 ? void 0 : _datasetIntegrationMa.title) || dataset.title,
      integration: (_datasetIntegrationMa2 = (_datasetIntegrationMa3 = datasetIntegrationMap[dataset.name]) === null || _datasetIntegrationMa3 === void 0 ? void 0 : _datasetIntegrationMa3.integration) !== null && _datasetIntegrationMa2 !== void 0 ? _datasetIntegrationMa2 : integrationsMap[(_dataStream$integrati = dataStream.integration) !== null && _dataStream$integrati !== void 0 ? _dataStream$integrati : ''],
      degradedDocs,
      failedDocs,
      docsInTimeRange: ((_totalDocsMap$dataset4 = totalDocsMap[dataset.rawName]) !== null && _totalDocsMap$dataset4 !== void 0 ? _totalDocsMap$dataset4 : 0) + ((_failedMap$dataset$ra = (_failedMap$dataset$ra2 = failedMap[dataset.rawName]) === null || _failedMap$dataset$ra2 === void 0 ? void 0 : _failedMap$dataset$ra2.count) !== null && _failedMap$dataset$ra !== void 0 ? _failedMap$dataset$ra : 0),
      quality: (0, _utils.mapPercentageToQuality)(qualityStats)
    };
  });
}