"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TelemetryService = void 0;
var _telemetry_events = require("./telemetry_events");
var _telemetry_client = require("./telemetry_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Service that interacts with the Core's analytics module
 */
class TelemetryService {
  constructor(analytics) {
    this.analytics = analytics;
  }
  setup({
    analytics
  }) {
    this.analytics = analytics;
    analytics.registerEventType(_telemetry_events.datasetQualityEbtEvents.datasetNavigatedEventType);
    analytics.registerEventType(_telemetry_events.datasetQualityEbtEvents.datasetDetailsOpenedEventType);
    analytics.registerEventType(_telemetry_events.datasetQualityEbtEvents.datasetDetailsNavigatedEventType);
    analytics.registerEventType(_telemetry_events.datasetQualityEbtEvents.datasetDetailsBreakdownFieldChangedEventType);
  }
  start() {
    if (!this.analytics) {
      throw new Error('The TelemetryService.setup() method has not been invoked, be sure to call it during the plugin setup.');
    }
    return new _telemetry_client.TelemetryClient(this.analytics);
  }
}
exports.TelemetryService = TelemetryService;