"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDatasetQualityDetailsState = void 0;
var _react = require("react");
var _react2 = require("@xstate/react");
var _constants = require("../../common/constants");
var _context = require("../components/dataset_quality_details/context");
var _utils = require("../../common/utils");
var _utils2 = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDatasetQualityDetailsState = () => {
  var _useSelector, _dataStreamSettings$d;
  const {
    service,
    telemetryClient,
    isFailureStoreEnabled
  } = (0, _context.useDatasetQualityDetailsContext)();
  const {
    services: {
      fieldFormats
    }
  } = (0, _utils2.useKibanaContextForPlugin)();
  const {
    dataStream,
    qualityIssues,
    timeRange,
    breakdownField,
    isIndexNotFoundError,
    expandedQualityIssue
  } = (_useSelector = (0, _react2.useSelector)(service, state => state.context)) !== null && _useSelector !== void 0 ? _useSelector : {};
  const isNonAggregatable = (0, _react2.useSelector)(service, state => state.matches('initializing.nonAggregatableDataset.done') ? state.context.isNonAggregatable : false);
  const isBreakdownFieldEcs = (0, _react2.useSelector)(service, state => state.matches('initializing.checkBreakdownFieldIsEcs.done') ? state.context.isBreakdownFieldEcs : false);
  const isBreakdownFieldAsserted = (0, _react2.useSelector)(service, state => state.matches('initializing.checkBreakdownFieldIsEcs.done') && breakdownField && isBreakdownFieldEcs);
  const dataStreamSettings = (0, _react2.useSelector)(service, state => state.matches('initializing.dataStreamSettings.qualityIssues.dataStreamDegradedFields.fetchingDataStreamDegradedFields') || state.matches('initializing.dataStreamSettings.doneFetchingQualityIssues') || state.matches('initializing.dataStreamSettings.qualityIssues.dataStreamDegradedFields.errorFetchingDegradedFields') || state.matches('initializing.dataStreamSettings.qualityIssues.dataStreamFailedDocs.fetchingFailedDocs') || state.matches('initializing.dataStreamSettings.qualityIssues.dataStreamFailedDocs.errorFetchingFailedDocs') ? state.context.dataStreamSettings : undefined);
  const integrationDetails = {
    integration: (0, _react2.useSelector)(service, state => state.matches('initializing.checkAndLoadIntegrationAndDashboards.loadingIntegrationDashboards') || state.matches('initializing.checkAndLoadIntegrationAndDashboards.unauthorizedToLoadDashboards') || state.matches('initializing.checkAndLoadIntegrationAndDashboards.done') ? state.context.integration : undefined),
    dashboard: (0, _react2.useSelector)(service, state => state.matches('initializing.checkAndLoadIntegrationAndDashboards.done') ? state.context.integrationDashboards : undefined)
  };
  const canUserAccessDashboards = (0, _react2.useSelector)(service, state => !state.matches('initializing.checkAndLoadIntegrationAndDashboards.unauthorizedToLoadDashboards'));
  const canUserViewIntegrations = Boolean(dataStreamSettings === null || dataStreamSettings === void 0 ? void 0 : (_dataStreamSettings$d = dataStreamSettings.datasetUserPrivileges) === null || _dataStreamSettings$d === void 0 ? void 0 : _dataStreamSettings$d.canViewIntegrations);
  const dataStreamDetails = (0, _react2.useSelector)(service, state => state.matches('initializing.dataStreamDetails.done') ? state.context.dataStreamDetails : undefined);
  const {
    type,
    dataset,
    namespace
  } = (0, _utils.indexNameToDataStreamParts)(dataStream);
  const datasetDetails = {
    type,
    name: dataset,
    namespace,
    rawName: dataStream
  };
  const docsTrendChart = (0, _react2.useSelector)(service, state => state.context.qualityIssuesChart);
  const loadingState = (0, _react2.useSelector)(service, state => ({
    nonAggregatableDatasetLoading: state.matches('initializing.nonAggregatableDataset.fetching'),
    dataStreamDetailsLoading: state.matches('initializing.dataStreamDetails.fetching'),
    dataStreamSettingsLoading: state.matches('initializing.dataStreamSettings.fetchingDataStreamSettings'),
    integrationDetailsLoading: state.matches('initializing.checkAndLoadIntegrationAndDashboards.checkingAndLoadingIntegration'),
    integrationDetailsLoaded: state.matches('initializing.checkAndLoadIntegrationAndDashboards.loadingIntegrationDashboards') || state.matches('initializing.checkAndLoadIntegrationAndDashboards.unauthorizedToLoadDashboards') || state.matches('initializing.checkAndLoadIntegrationAndDashboards.done'),
    integrationDashboardsLoading: state.matches('initializing.checkAndLoadIntegrationAndDashboards.loadingIntegrationDashboards')
  }));
  const isQualityIssueFlyoutOpen = (0, _react2.useSelector)(service, state => state.matches('initializing.qualityIssueFlyout.open'));
  const updateTimeRange = (0, _react.useCallback)(({
    start,
    end,
    refreshInterval
  }) => {
    service.send({
      type: 'UPDATE_TIME_RANGE',
      timeRange: {
        from: start,
        to: end,
        refresh: {
          ..._constants.DEFAULT_DATEPICKER_REFRESH,
          value: refreshInterval
        }
      }
    });
  }, [service]);
  return {
    service,
    telemetryClient,
    isFailureStoreEnabled,
    fieldFormats,
    isIndexNotFoundError,
    dataStream,
    datasetDetails,
    qualityIssues,
    dataStreamDetails,
    docsTrendChart,
    breakdownField,
    isBreakdownFieldEcs,
    isBreakdownFieldAsserted,
    isNonAggregatable,
    timeRange,
    loadingState,
    updateTimeRange,
    dataStreamSettings,
    integrationDetails,
    canUserAccessDashboards,
    canUserViewIntegrations,
    expandedQualityIssue,
    isQualityIssueFlyoutOpen
  };
};
exports.useDatasetQualityDetailsState = useDatasetQualityDetailsState;