"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFailedDocsErrorsColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const contentColumnName = _i18n.i18n.translate('xpack.datasetQuality.details.qualityIssue.failedDocs.erros.contentLabel', {
  defaultMessage: 'Content'
});
const typeColumnName = _i18n.i18n.translate('xpack.datasetQuality.details.qualityIssue.failedDocs.erros.typeLabel', {
  defaultMessage: 'Type'
});
const typeColumnTooltip = _i18n.i18n.translate('xpack.datasetQuality.details.qualityIssue.failedDocs.erros.typeTooltip', {
  defaultMessage: 'Error message category'
});
const getFailedDocsErrorsColumns = () => [{
  name: contentColumnName,
  field: 'message',
  render: (_, {
    message
  }) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      language: "js"
    }, message);
  }
}, {
  name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: typeColumnTooltip
  }, /*#__PURE__*/_react.default.createElement("span", null, `${typeColumnName} `, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "s",
    color: "subdued",
    type: "questionInCircle",
    className: "eui-alignTop"
  }))),
  field: 'type',
  render: (_, {
    type
  }) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow"
    }, /*#__PURE__*/_react.default.createElement("strong", null, type));
  },
  sortable: true
}];
exports.getFailedDocsErrorsColumns = getFailedDocsErrorsColumns;