"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = OverviewHeader;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _hooks = require("../../../hooks");
var _translations = require("../../../../common/translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Allow for lazy loading
// eslint-disable-next-line import/no-default-export
function OverviewHeader({
  handleRefresh
}) {
  const {
    timeRange,
    updateTimeRange
  } = (0, _hooks.useDatasetQualityDetailsState)();
  const onTimeChange = (0, _react2.useCallback)(({
    isInvalid,
    ...timeRangeProps
  }) => {
    if (!isInvalid) {
      updateTimeRange({
        refreshInterval: timeRange.refresh.value,
        ...timeRangeProps
      });
    }
  }, [updateTimeRange, timeRange.refresh]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    wrap: true
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react.css)`
          flex-grow: 1;
        `,
    justifyContent: "flexStart",
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react2.default.createElement("span", null, _translations.overviewHeaderTitle)), /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
    content: _translations.overviewTitleTooltip
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    size: "m",
    color: "subdued",
    type: "questionInCircle",
    className: "eui-alignTop"
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react.css)`
          flex-grow: 0;
        `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSuperDatePicker, {
    width: "auto",
    compressed: true,
    isLoading: false,
    start: timeRange.from,
    end: timeRange.to,
    onTimeChange: onTimeChange,
    onRefresh: handleRefresh,
    isQuickSelectOnly: false,
    showUpdateButton: "iconOnly",
    updateButtonProps: {
      fill: false
    }
  })));
}
module.exports = exports.default;