"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Header;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../common/constants");
var _translations = require("../../../common/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Allow for lazy loading
// eslint-disable-next-line import/no-default-export
function Header() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    bottomBorder: true,
    pageTitle: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _translations.datasetQualityAppTitle, "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      label: betaBadgeLabel,
      title: betaBadgeLabel,
      tooltipContent: betaBadgeDescription
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.datasetQuality.appDescription",
      defaultMessage: "Monitor the data set quality for {types} data streams that follow the {dsNamingSchemeLink}.",
      values: {
        types: _constants.KNOWN_TYPES.map((type, index) => {
          return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, index > 0 && ', ', /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, type));
        }),
        dsNamingSchemeLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "datasetQualityAppDescriptionDsNamingSchemeLink",
          href: "https://ela.st/data-stream-naming-scheme",
          target: "_blank",
          rel: "noopener"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.datasetQuality.appDescription.dsNamingSchemeLinkText",
          defaultMessage: "Data stream naming scheme"
        }))
      }
    })
  });
}
const betaBadgeLabel = _i18n.i18n.translate('xpack.datasetQuality.betaBadgeLabel', {
  defaultMessage: 'Beta'
});
const betaBadgeDescription = _i18n.i18n.translate('xpack.datasetQuality.betaBadgeDescription', {
  defaultMessage: 'This feature is currently in beta. If you encounter any bugs or have feedback, we’d love to hear from you. Please open a support issue and/or visit our discussion forum.'
});
module.exports = exports.default;