"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverallUploadStatus = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _file_manager = require("./file_manager/file_manager");
var _file_status = require("./file_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OverallUploadStatus = ({
  filesStatus,
  uploadStatus
}) => {
  const generateStatus = statuses => {
    if (statuses.includes(_file_manager.STATUS.STARTED)) {
      return 'current';
    } else if (statuses.includes(_file_manager.STATUS.FAILED)) {
      return 'danger';
    } else if (statuses.every(status => status === _file_manager.STATUS.COMPLETED)) {
      return 'complete';
    } else {
      return 'incomplete';
    }
  };
  const css = {
    '.euiStep__content': {
      paddingBlockEnd: '0px'
    }
  };
  const steps = [...(uploadStatus.modelDeployed === _file_manager.STATUS.NA ? [] : [{
    title: _i18n.i18n.translate('xpack.dataVisualizer.file.overallUploadStatus.deployingModel', {
      defaultMessage: 'Deploying model'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null),
    status: generateStatus([uploadStatus.modelDeployed])
  }]), {
    title: _i18n.i18n.translate('xpack.dataVisualizer.file.overallUploadStatus.creatingIndexAndIngestPipeline', {
      defaultMessage: 'Creating index and ingest pipeline'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null),
    status: generateStatus([uploadStatus.indexCreated, uploadStatus.pipelineCreated])
  }, {
    title: _i18n.i18n.translate('xpack.dataVisualizer.file.overallUploadStatus.uploadingFiles', {
      defaultMessage: 'Uploading files'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, filesStatus.map((status, i) => /*#__PURE__*/_react.default.createElement(_file_status.FileStatus, {
      uploadStatus: uploadStatus,
      fileStatus: status,
      key: i,
      deleteFile: () => {},
      index: i
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)),
    status: generateStatus([uploadStatus.fileImport])
  }, {
    title: _i18n.i18n.translate('xpack.dataVisualizer.file.overallUploadStatus.creatingDataView', {
      defaultMessage: 'Creating data view'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null),
    status: generateStatus([uploadStatus.dataViewCreated])
  }, {
    title: _i18n.i18n.translate('xpack.dataVisualizer.file.overallUploadStatus.uploadComplete', {
      defaultMessage: 'Upload complete'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null),
    status: uploadStatus.overallImportStatus === _file_manager.STATUS.COMPLETED ? 'complete' : 'incomplete'
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: steps,
    titleSize: "xxs",
    css: css
  }));
};
exports.OverallUploadStatus = OverallUploadStatus;