"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResultsView = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../../common/constants");
var _file_contents = require("../file_contents");
var _analysis_summary = require("../analysis_summary");
var _fields_stats_grid = require("../../../common/components/fields_stats_grid");
var _constants2 = require("../file_data_visualizer_view/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ResultsView = ({
  fileContents,
  fileName,
  results,
  showEditFlyout,
  showExplanationFlyout,
  disableButtons,
  onChangeMode,
  onCancel,
  disableImport
}) => {
  const semiStructureTextData = results.format === _constants.FILE_FORMATS.SEMI_STRUCTURED_TEXT ? {
    grokPattern: results.grok_pattern,
    multilineStartPattern: results.multiline_start_pattern,
    sampleStart: results.sample_start,
    excludeLinesPattern: results.exclude_lines_pattern,
    mappings: results.mappings,
    ecsCompatibility: results.ecs_compatibility
  } : null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    "data-test-subj": "dataVisualizerPageFileResults"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": "dataVisualizerFileResultsTitle"
  }, fileName))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel,
    "data-test-subj": "dataVisualizerFileResultsCancelButton",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.resultsView.cancelButtonLabel",
    defaultMessage: "Select a different file"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "dataVisualizerFileFileContentPanel",
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_file_contents.FileContents, {
    fileContents: fileContents,
    format: results.format,
    numberOfLines: results.num_lines_analyzed,
    semiStructureTextData: semiStructureTextData
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "dataVisualizerFileSummaryPanel",
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_analysis_summary.AnalysisSummary, {
    results: results
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    isDisabled: disableImport,
    onClick: () => onChangeMode(_constants2.MODE.IMPORT),
    "data-test-subj": "dataVisualizerFileOpenImportPageButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.resultsView.importButtonLabel",
    defaultMessage: "Import"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => showEditFlyout(),
    disabled: disableButtons
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.resultsView.overrideSettingsButtonLabel",
    defaultMessage: "Override settings"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, results.format !== _constants.FILE_FORMATS.TIKA ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => showExplanationFlyout(),
    disabled: disableButtons
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.resultsView.analysisExplanationButtonLabel",
    defaultMessage: "Analysis explanation"
  })) : null))), results.format !== _constants.FILE_FORMATS.TIKA ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "dataVisualizerFileFileStatsPanel",
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": "dataVisualizerFileStatsTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.resultsView.fileStatsName",
    defaultMessage: "File stats"
  }))), /*#__PURE__*/_react.default.createElement(_fields_stats_grid.FieldsStatsGrid, {
    results: results
  }))) : null));
};
exports.ResultsView = ResultsView;