"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImportView = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _public = require("@kbn/kibana-react-plugin/public");
var _results_links = require("../../../common/components/results_links");
var _filebeat_config_flyout = require("../../../common/components/filebeat_config_flyout");
var _import_progress = require("../import_progress");
var _import_errors = require("../import_errors");
var _import_summary = require("../import_summary");
var _import_settings = require("../import_settings");
var _doc_count_chart = require("../doc_count_chart");
var _combined_fields = require("../../../common/components/combined_fields");
var _constants = require("../file_data_visualizer_view/constants");
var _import = require("./import");
var _constants2 = require("../../../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_INDEX_SETTINGS = {};
const CONFIG_MODE = {
  SIMPLE: 0,
  ADVANCED: 1
};
const DEFAULT_STATE = {
  index: '',
  importing: false,
  imported: false,
  initialized: false,
  reading: false,
  readProgress: 0,
  readStatus: _import_progress.IMPORT_STATUS.INCOMPLETE,
  parseJSONStatus: _import_progress.IMPORT_STATUS.INCOMPLETE,
  indexCreatedStatus: _import_progress.IMPORT_STATUS.INCOMPLETE,
  dataViewCreatedStatus: _import_progress.IMPORT_STATUS.INCOMPLETE,
  ingestPipelineCreatedStatus: _import_progress.IMPORT_STATUS.INCOMPLETE,
  permissionCheckStatus: _import_progress.IMPORT_STATUS.INCOMPLETE,
  uploadProgress: 0,
  uploadStatus: _import_progress.IMPORT_STATUS.INCOMPLETE,
  createDataView: true,
  dataView: '',
  dataViewId: '',
  pipelineId: null,
  errors: [],
  importFailures: [],
  docCount: 0,
  configMode: CONFIG_MODE.SIMPLE,
  indexSettingsString: '',
  mappingsString: '',
  pipelineString: '',
  indexNames: [],
  dataViewNames: [],
  indexNameError: '',
  dataViewNameError: '',
  timeFieldName: undefined,
  isFilebeatFlyoutVisible: false,
  checkingValidIndex: false,
  combinedFields: [],
  importer: undefined,
  createPipeline: true,
  initializeDeployment: false,
  initializeDeploymentStatus: _import_progress.IMPORT_STATUS.INCOMPLETE,
  inferenceId: null
};
class ImportView extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "clickReset", () => {
      const state = getDefaultState(this.state, this.props.results, this.props.capabilities);
      this.setState(state, () => {
        this.loadDataViewNames();
      });
    });
    (0, _defineProperty2.default)(this, "clickImport", () => {
      const {
        data,
        results
      } = this.props;
      const {
        data: {
          dataViews: dataViewsContract
        },
        fileUpload,
        http
      } = this.context.services;
      const {
        index,
        dataView,
        createDataView,
        indexSettingsString,
        mappingsString,
        pipelineString,
        pipelineId
      } = this.state;
      const createPipeline = pipelineString !== '';
      this.setState({
        createPipeline
      });
      (0, _import.importData)({
        data,
        results,
        dataViewsContract,
        fileUpload,
        http
      }, {
        index,
        dataView,
        createDataView,
        indexSettingsString,
        mappingsString,
        pipelineString,
        pipelineId,
        createPipeline
      }, state => this.setState(state));
    });
    (0, _defineProperty2.default)(this, "onConfigModeChange", configMode => {
      this.setState({
        configMode
      });
    });
    (0, _defineProperty2.default)(this, "onIndexChange", index => {
      this.setState({
        index,
        checkingValidIndex: true
      });
      this.debounceIndexCheck(index);
    });
    (0, _defineProperty2.default)(this, "debounceIndexCheck", (0, _lodash.debounce)(async index => {
      if (index === '') {
        this.setState({
          checkingValidIndex: false
        });
        return;
      }
      const exists = await this.context.services.fileUpload.checkIndexExists(index);
      const indexNameError = exists ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.importView.indexNameAlreadyExistsErrorMessage",
        defaultMessage: "Index name already exists"
      }) : isIndexNameValid(index);
      this.setState({
        checkingValidIndex: false,
        indexNameError
      });
    }, 500));
    (0, _defineProperty2.default)(this, "onDataViewChange", e => {
      const name = e.target.value;
      const {
        dataViewNames,
        index
      } = this.state;
      this.setState({
        dataView: name,
        dataViewNameError: isDataViewNameValid(name, dataViewNames, index)
      });
    });
    (0, _defineProperty2.default)(this, "onCreateDataViewChange", e => {
      this.setState({
        createDataView: e.target.checked
      });
    });
    (0, _defineProperty2.default)(this, "onIndexSettingsStringChange", text => {
      this.setState({
        indexSettingsString: text
      });
    });
    (0, _defineProperty2.default)(this, "onMappingsStringChange", text => {
      this.setState({
        mappingsString: text
      });
    });
    (0, _defineProperty2.default)(this, "onPipelineStringChange", text => {
      this.setState({
        pipelineString: text
      });
    });
    (0, _defineProperty2.default)(this, "onPipelineIdChange", text => {
      this.setState({
        pipelineId: text
      });
    });
    (0, _defineProperty2.default)(this, "onCreatePipelineChange", b => {
      this.setState({
        createPipeline: b
      });
    });
    (0, _defineProperty2.default)(this, "onCombinedFieldsChange", combinedFields => {
      this.setState({
        combinedFields
      });
    });
    (0, _defineProperty2.default)(this, "setReadProgress", progress => {
      this.setState({
        readProgress: progress
      });
    });
    (0, _defineProperty2.default)(this, "showFilebeatFlyout", () => {
      this.setState({
        isFilebeatFlyoutVisible: true
      });
    });
    (0, _defineProperty2.default)(this, "closeFilebeatFlyout", () => {
      this.setState({
        isFilebeatFlyoutVisible: false
      });
    });
    (0, _defineProperty2.default)(this, "closeFilebeatFlyout", () => {
      this.setState({
        isFilebeatFlyoutVisible: false
      });
    });
    this.state = getDefaultState(DEFAULT_STATE, this.props.results, this.props.capabilities);
  }
  componentDidMount() {
    this.loadDataViewNames();
  }
  async loadDataViewNames() {
    try {
      const dataViewNames = await this.context.services.data.dataViews.getTitles();
      this.setState({
        dataViewNames
      });
    } catch (error) {
      console.error('failed to load data views', error);
    }
  }
  render() {
    var _this$props$getAdditi;
    const {
      index,
      dataView,
      dataViewId,
      pipelineId,
      importing,
      imported,
      reading,
      initialized,
      readStatus,
      parseJSONStatus,
      indexCreatedStatus,
      ingestPipelineCreatedStatus,
      dataViewCreatedStatus,
      permissionCheckStatus,
      uploadProgress,
      uploadStatus,
      createDataView,
      errors,
      docCount,
      importFailures,
      indexSettingsString,
      mappingsString,
      pipelineString,
      indexNameError,
      dataViewNameError,
      timeFieldName,
      isFilebeatFlyoutVisible,
      checkingValidIndex,
      combinedFields,
      importer,
      createPipeline,
      initializeDeployment,
      initializeDeploymentStatus
    } = this.state;
    const statuses = {
      reading,
      readStatus,
      parseJSONStatus,
      indexCreatedStatus,
      ingestPipelineCreatedStatus,
      dataViewCreatedStatus,
      permissionCheckStatus,
      uploadProgress,
      uploadStatus,
      createDataView,
      createPipeline,
      initializeDeployment,
      initializeDeploymentStatus
    };
    const disableImport = index === '' || indexNameError !== '' || createDataView === true && dataViewNameError !== '' || initialized === true || checkingValidIndex === true;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
      "data-test-subj": "dataVisualizerPageFileImport"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h1", null, this.props.fileName))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), initialized === false ? /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      "data-test-subj": "dataVisualizerFileImportSettingsPanel",
      hasShadow: false,
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.importView.importDataTitle",
      defaultMessage: "Import data"
    }))), /*#__PURE__*/_react.default.createElement(_import_settings.ImportSettings, {
      index: index,
      dataView: dataView,
      initialized: initialized,
      onIndexChange: this.onIndexChange,
      createDataView: createDataView,
      onCreateDataViewChange: this.onCreateDataViewChange,
      onDataViewChange: this.onDataViewChange,
      indexSettingsString: indexSettingsString,
      mappingsString: mappingsString,
      pipelineString: pipelineString,
      onIndexSettingsStringChange: this.onIndexSettingsStringChange,
      onMappingsStringChange: this.onMappingsStringChange,
      onPipelineStringChange: this.onPipelineStringChange,
      indexNameError: indexNameError,
      dataViewNameError: dataViewNameError,
      combinedFields: combinedFields,
      onCombinedFieldsChange: this.onCombinedFieldsChange,
      results: this.props.results
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      isDisabled: disableImport,
      onClick: this.clickImport,
      isLoading: importing,
      iconSide: "right",
      fill: true,
      "data-test-subj": "dataVisualizerFileImportButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.importView.importButtonLabel",
      defaultMessage: "Import"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: () => this.props.onChangeMode(_constants.MODE.READ),
      isDisabled: importing
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.importView.backButtonLabel",
      defaultMessage: "Back"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: () => this.props.onCancel(),
      isDisabled: importing
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.importView.cancelButtonLabel",
      defaultMessage: "Select a different file"
    }))))) : null, initialized === true && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasShadow: false,
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(_import_progress.ImportProgress, {
      statuses: statuses
    }), importer !== undefined && importer.initialized() && this.props.results.format !== _constants2.FILE_FORMATS.TIKA && /*#__PURE__*/_react.default.createElement(_doc_count_chart.DocCountChart, {
      statuses: statuses,
      dataStart: this.context.services.data,
      importer: importer
    }), imported === true && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_import_summary.ImportSummary, {
      index: index,
      dataView: dataView === '' ? index : dataView,
      pipelineId: pipelineId,
      docCount: docCount,
      importFailures: importFailures,
      createDataView: createDataView,
      createPipeline: createPipeline
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: this.clickReset
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.importView.resetButtonLabel",
      defaultMessage: "Reset"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: () => this.props.onCancel(),
      isDisabled: importing
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.importView.importNewButtonLabel",
      defaultMessage: "Import a new file"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_results_links.ResultsLinks, {
      results: this.props.results,
      index: index,
      dataViewId: dataViewId,
      timeFieldName: timeFieldName,
      createDataView: createDataView,
      showFilebeatFlyout: this.showFilebeatFlyout,
      getAdditionalLinks: (_this$props$getAdditi = this.props.getAdditionalLinks) !== null && _this$props$getAdditi !== void 0 ? _this$props$getAdditi : [],
      resultLinks: this.props.resultLinks,
      combinedFields: combinedFields
    }), isFilebeatFlyoutVisible && /*#__PURE__*/_react.default.createElement(_filebeat_config_flyout.FilebeatConfigFlyout, {
      index: index,
      results: this.props.results,
      pipelineId: pipelineId,
      closeFlyout: this.closeFilebeatFlyout
    })))), errors.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_import_errors.ImportErrors, {
      errors: errors,
      statuses: statuses
    })));
  }
}
exports.ImportView = ImportView;
(0, _defineProperty2.default)(ImportView, "contextType", _public.context);
function getDefaultState(state, results, capabilities) {
  const indexSettingsString = state.indexSettingsString === '' ? JSON.stringify(DEFAULT_INDEX_SETTINGS, null, 2) : state.indexSettingsString;
  const combinedFields = state.combinedFields.length ? state.combinedFields : (0, _combined_fields.getDefaultCombinedFields)(results);
  const mappingsString = state.mappingsString === '' ? JSON.stringify((0, _combined_fields.addCombinedFieldsToMappings)(results.mappings, combinedFields), null, 2) : state.mappingsString;
  const pipelineString = state.pipelineString === '' && results.ingest_pipeline !== undefined ? JSON.stringify((0, _combined_fields.addCombinedFieldsToPipeline)(results.ingest_pipeline, combinedFields), null, 2) : state.pipelineString;
  const timeFieldName = results.timestamp_field;
  const createDataView = capabilities.savedObjectsManagement.edit === false && capabilities.indexPatterns.save === false ? false : state.createDataView;
  return {
    ...DEFAULT_STATE,
    indexSettingsString,
    mappingsString,
    pipelineString,
    timeFieldName,
    combinedFields,
    createDataView
  };
}
function isIndexNameValid(name) {
  const reg = new RegExp('[\\\\/*?"<>|\\s,#]+');
  if (name !== name.toLowerCase() ||
  // name should be lowercase
  name === '.' || name === '..' ||
  // name can't be . or ..
  name.match(/^[-_+]/) !== null ||
  // name can't start with these chars
  name.match(reg) !== null // name can't contain these chars
  ) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.importView.indexNameContainsIllegalCharactersErrorMessage",
      defaultMessage: "Index name contains illegal characters"
    });
  }
  return '';
}
function isDataViewNameValid(name, dataViewNames, index) {
  // if a blank name is entered, the index name will be used so avoid validation
  if (name === '') {
    return '';
  }
  if (dataViewNames.find(i => i === name)) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.importView.dataViewNameAlreadyExistsErrorMessage",
      defaultMessage: "Data view name already exists"
    });
  }

  // escape . and + to stop the regex matching more than it should.
  let newName = name.replace(/\./g, '\\.');
  newName = newName.replace(/\+/g, '\\+');
  // replace * with .* to make the wildcard match work.
  newName = newName.replace(/\*/g, '.*');
  const reg = new RegExp(`^${newName}$`);
  if (index.match(reg) === null) {
    // name should match index
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.importView.indexPatternDoesNotMatchDataViewErrorMessage",
      defaultMessage: "Data view does not match index name"
    });
  }
  return '';
}