"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentCountWithBrush = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _use_state_manager = require("./use_state_manager");
var _kibana_context = require("../kibana_context");
var _total_count_header = require("../common/components/document_count_content/total_count_header");
var _random_sampling_menu = require("../common/components/random_sampling_menu/random_sampling_menu");
var _get_data_test_subject = require("../common/util/get_data_test_subject");
var _document_count_chart_single_brush = require("./document_count_chart_single_brush");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DocumentCountWithBrush = ({
  id,
  randomSampler,
  reload,
  brushSelectionUpdateHandler,
  documentCountStats,
  documentCountStatsSplit,
  documentCountStatsSplitLabel = '',
  isBrushCleared,
  totalCount,
  sampleProbability,
  initialAnalysisStart,
  barColorOverride,
  barHighlightColorOverride,
  incomingInitialAnalysisStart,
  stateManager,
  label,
  ...docCountChartProps
}) => {
  var _documentCountStats$b, _documentCountStatsSp;
  const {
    services: {
      data,
      uiSettings,
      fieldFormats,
      charts,
      unifiedSearch: {
        ui: {
          SearchBar
        }
      }
    }
  } = (0, _kibana_context.useDataVisualizerKibana)();
  const {
    dataView
  } = (0, _use_state_manager.useDataDriftStateManagerContext)();
  const approximate = (0, _useObservable.default)(randomSampler.getProbability$().pipe((0, _rxjs.map)(samplingProbability => (0, _mlIsDefined.isDefined)(samplingProbability) ? samplingProbability < 1 : false)), false);
  const bucketTimestamps = Object.keys((_documentCountStats$b = documentCountStats === null || documentCountStats === void 0 ? void 0 : documentCountStats.buckets) !== null && _documentCountStats$b !== void 0 ? _documentCountStats$b : {}).map(time => +time);
  const splitBucketTimestamps = Object.keys((_documentCountStatsSp = documentCountStatsSplit === null || documentCountStatsSplit === void 0 ? void 0 : documentCountStatsSplit.buckets) !== null && _documentCountStatsSp !== void 0 ? _documentCountStatsSp : {}).map(time => +time);
  const timeRangeEarliest = Math.min(...[...bucketTimestamps, ...splitBucketTimestamps]);
  const timeRangeLatest = Math.max(...[...bucketTimestamps, ...splitBucketTimestamps]);
  if (dataView.getTimeField() === undefined) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "m",
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs"
    }, /*#__PURE__*/_react.default.createElement("h3", null, label)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "m",
      direction: "row",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(SearchBar, {
      key: `dataDrift-${stateManager.id}`,
      dataTestSubj: "dataVisualizerQueryInput",
      appName: 'dataVisualizer',
      showFilterBar: true,
      showDatePicker: false,
      showQueryInput: false,
      filters: stateManager.filters,
      onFiltersUpdated: filters => stateManager.setFilters(filters),
      indexPatterns: [dataView],
      displayStyle: 'inPage',
      isClearable: true
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_random_sampling_menu.SamplingMenu, {
      randomSampler: randomSampler,
      reload: reload
    }))));
  }
  if (documentCountStats === undefined || documentCountStats.buckets === undefined || timeRangeEarliest === undefined || timeRangeLatest === undefined) {
    return totalCount !== undefined ? /*#__PURE__*/_react.default.createElement(_total_count_header.TotalCountHeader, {
      totalCount: totalCount,
      id: id
    }) : null;
  }
  const chartPoints = Object.entries(documentCountStats.buckets).map(([time, value]) => ({
    time: +time,
    value
  }));
  let chartPointsSplit;
  if ((documentCountStatsSplit === null || documentCountStatsSplit === void 0 ? void 0 : documentCountStatsSplit.buckets) !== undefined) {
    chartPointsSplit = Object.entries(documentCountStatsSplit === null || documentCountStatsSplit === void 0 ? void 0 : documentCountStatsSplit.buckets).map(([time, value]) => ({
      time: +time,
      value
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column",
    "data-test-subj": (0, _get_data_test_subject.getDataTestSubject)('dataDriftTotalDocCountHeader', id)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_total_count_header.TotalCountHeader, {
    totalCount: totalCount,
    approximate: approximate,
    label: label,
    id: id
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "row",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(SearchBar, {
    key: `dataDrift-${stateManager.id}`,
    dataTestSubj: "dataVisualizerQueryInput",
    appName: 'dataVisualizer',
    showFilterBar: true,
    showDatePicker: false,
    showQueryInput: false,
    filters: stateManager.filters,
    onFiltersUpdated: filters => stateManager.setFilters(filters),
    indexPatterns: [dataView],
    displayStyle: 'inPage',
    isClearable: true,
    customSubmitButton: /*#__PURE__*/_react.default.createElement("div", null)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_random_sampling_menu.SamplingMenu, {
    randomSampler: randomSampler,
    reload: reload,
    id: id
  }))), documentCountStats.interval !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_document_count_chart_single_brush.DocumentCountChartWithBrush, (0, _extends2.default)({
    id: id,
    dependencies: {
      data,
      uiSettings,
      fieldFormats,
      charts
    },
    brushSelectionUpdateHandler: brushSelectionUpdateHandler,
    chartPoints: chartPoints,
    chartPointsSplit: chartPointsSplit,
    timeRangeEarliest: timeRangeEarliest,
    timeRangeLatest: timeRangeLatest,
    interval: documentCountStats.interval,
    chartPointsSplitLabel: documentCountStatsSplitLabel,
    isBrushCleared: isBrushCleared,
    autoAnalysisStart: initialAnalysisStart,
    barColorOverride: barColorOverride,
    barHighlightColorOverride: barHighlightColorOverride
  }, docCountChartProps, {
    height: 60,
    dataTestSubj: (0, _get_data_test_subject.getDataTestSubject)('dataDriftDocCountChart', id)
  }))));
};
exports.DocumentCountWithBrush = DocumentCountWithBrush;