"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HelpMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kibana_context = require("../../../kibana_context");
var _constants = require("../../constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Component for adding a documentation link to the help menu
const HelpMenu = exports.HelpMenu = /*#__PURE__*/_react.default.memo(({
  docLink
}) => {
  const {
    chrome
  } = (0, _kibana_context.useDataVisualizerKibana)().services;
  (0, _react.useEffect)(() => {
    chrome.setHelpExtension({
      appName: _constants.INDEX_DATA_VISUALIZER_NAME,
      links: [{
        href: docLink,
        linkType: 'documentation'
      }]
    });
  }, [chrome, docLink]);
  return null;
});
HelpMenu.displayName = 'HelpMenu';