"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runtimeResponseSchema = exports.indexPatternsRuntimeResponseSchema = exports.dataViewsRuntimeResponseSchema = exports.dataViewSpecSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../constants");
var _schemas = require("../schemas");
var _constants2 = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const dataViewSpecSchema = exports.dataViewSpecSchema = _configSchema.schema.object({
  title: _configSchema.schema.string(),
  version: _configSchema.schema.maybe(_configSchema.schema.string()),
  id: _configSchema.schema.maybe(_configSchema.schema.string()),
  type: _configSchema.schema.maybe(_configSchema.schema.string()),
  timeFieldName: _configSchema.schema.maybe(_configSchema.schema.string()),
  sourceFilters: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
    value: _configSchema.schema.string(),
    clientId: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.number()]))
  }))),
  fields: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _schemas.fieldSpecSchema)),
  typeMeta: _configSchema.schema.maybe(_configSchema.schema.object({}, {
    unknowns: 'allow'
  })),
  fieldFormats: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _schemas.serializedFieldFormatSchema)),
  fieldAttrs: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.object({
    customLabel: _configSchema.schema.maybe(_configSchema.schema.string()),
    customDescription: _configSchema.schema.maybe(_configSchema.schema.string({
      maxLength: _constants2.MAX_DATA_VIEW_FIELD_DESCRIPTION_LENGTH
    })),
    count: _configSchema.schema.maybe(_configSchema.schema.number())
  }))),
  allowNoIndex: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  runtimeFieldMap: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _schemas.runtimeFieldSchema)),
  name: _configSchema.schema.maybe(_configSchema.schema.string()),
  namespaces: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  allowHidden: _configSchema.schema.maybe(_configSchema.schema.boolean())
});
const dataViewsRuntimeResponseSchema = () => _configSchema.schema.object({
  [_constants.SERVICE_KEY]: dataViewSpecSchema,
  fields: _configSchema.schema.arrayOf(_configSchema.schema.object(_schemas.fieldSpecSchemaFields))
});
exports.dataViewsRuntimeResponseSchema = dataViewsRuntimeResponseSchema;
const indexPatternsRuntimeResponseSchema = () => _configSchema.schema.object({
  [_constants.SERVICE_KEY_LEGACY]: dataViewSpecSchema,
  field: _configSchema.schema.object(_schemas.fieldSpecSchemaFields)
});
exports.indexPatternsRuntimeResponseSchema = indexPatternsRuntimeResponseSchema;
const runtimeResponseSchema = () => _configSchema.schema.oneOf([dataViewsRuntimeResponseSchema(), indexPatternsRuntimeResponseSchema()]);
exports.runtimeResponseSchema = runtimeResponseSchema;