"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setDefault = exports.registerManageDefaultDataViewRouteLegacy = exports.registerManageDefaultDataViewRoute = exports.getDefault = void 0;
var _configSchema = require("@kbn/config-schema");
var _handle_errors = require("./util/handle_errors");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getDefault = async ({
  dataViewsService,
  usageCollection,
  counterName
}) => {
  usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.incrementCounter({
    counterName
  });
  return dataViewsService.getDefaultId();
};
exports.getDefault = getDefault;
const setDefault = async ({
  dataViewsService,
  usageCollection,
  counterName,
  newDefaultId,
  force
}) => {
  usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.incrementCounter({
    counterName
  });
  return dataViewsService.setDefault(newDefaultId, force);
};
exports.setDefault = setDefault;
const manageDefaultIndexPatternRoutesFactory = (path, serviceKey, getDescription, postDescription) => (router, getStartServices, usageCollection) => {
  router.versioned.get({
    path,
    access: 'public',
    description: getDescription
  }).addVersion({
    version: _constants.INITIAL_REST_VERSION,
    security: {
      authz: {
        enabled: false,
        reason: 'Authorization provided by saved objects client'
      }
    },
    validate: {
      request: {},
      response: {
        200: {
          body: () => _configSchema.schema.object({
            [`${serviceKey}_id`]: _configSchema.schema.string()
          })
        }
      }
    }
  }, (0, _handle_errors.handleErrors)(async (ctx, req, res) => {
    const core = await ctx.core;
    const savedObjectsClient = core.savedObjects.client;
    const elasticsearchClient = core.elasticsearch.client.asCurrentUser;
    const [,, {
      dataViewsServiceFactory
    }] = await getStartServices();
    const dataViewsService = await dataViewsServiceFactory(savedObjectsClient, elasticsearchClient, req);
    const id = await getDefault({
      dataViewsService,
      usageCollection,
      counterName: `${req.route.method} ${path}`
    });
    return res.ok({
      body: {
        [`${serviceKey}_id`]: id
      }
    });
  }));
  router.versioned.post({
    path,
    access: 'public',
    description: postDescription
  }).addVersion({
    version: _constants.INITIAL_REST_VERSION,
    security: {
      authz: {
        requiredPrivileges: ['indexPatterns:manage']
      }
    },
    validate: {
      request: {
        body: _configSchema.schema.object({
          [`${serviceKey}_id`]: _configSchema.schema.nullable(_configSchema.schema.string({
            minLength: 1,
            maxLength: 1_000
          })),
          force: _configSchema.schema.boolean({
            defaultValue: false
          })
        })
      },
      response: {
        200: {
          body: () => _configSchema.schema.object({
            acknowledged: _configSchema.schema.boolean()
          })
        }
      }
    }
  }, (0, _handle_errors.handleErrors)(async (ctx, req, res) => {
    const core = await ctx.core;
    const savedObjectsClient = core.savedObjects.client;
    const elasticsearchClient = core.elasticsearch.client.asCurrentUser;
    const [,, {
      dataViewsServiceFactory
    }] = await getStartServices();
    const dataViewsService = await dataViewsServiceFactory(savedObjectsClient, elasticsearchClient, req);
    const newDefaultId = req.body[`${serviceKey}_id`];
    const force = req.body.force;
    await setDefault({
      dataViewsService,
      usageCollection,
      counterName: `${req.route.method} ${path}`,
      newDefaultId,
      force
    });
    return res.ok({
      body: {
        acknowledged: true
      }
    });
  }));
};
const registerManageDefaultDataViewRoute = exports.registerManageDefaultDataViewRoute = manageDefaultIndexPatternRoutesFactory(`${_constants.SERVICE_PATH}/default`, _constants.SERVICE_KEY, _constants.GET_DEFAULT_DATA_VIEW_DESCRIPTION, _constants.SET_DEFAULT_DATA_VIEW_DESCRIPTION);
const registerManageDefaultDataViewRouteLegacy = exports.registerManageDefaultDataViewRouteLegacy = manageDefaultIndexPatternRoutesFactory(`${_constants.SERVICE_PATH_LEGACY}/default`, _constants.SERVICE_KEY_LEGACY);