"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedParametersSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const AdvancedParametersSection = ({
  children
}) => {
  const [isVisible, setIsVisible] = (0, _react.useState)(false);
  const toggleIsVisible = () => {
    setIsVisible(!isVisible);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: toggleIsVisible,
    flush: "left",
    "data-test-subj": "toggleAdvancedSetting"
  }, isVisible ? _i18n.i18n.translate('indexPatternFieldEditor.editor.form.advancedSettings.hideButtonLabel', {
    defaultMessage: 'Hide advanced settings'
  }) : _i18n.i18n.translate('indexPatternFieldEditor.editor.form.advancedSettings.showButtonLabel', {
    defaultMessage: 'Show advanced settings'
  })), /*#__PURE__*/_react.default.createElement("div", {
    css: {
      display: isVisible ? 'block' : 'none'
    },
    "data-test-subj": "advancedSettings"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement("div", null, children)));
};
exports.AdvancedParametersSection = AdvancedParametersSection;