"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.editDataViewModal = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const editDataViewModal = ({
  dataViewName,
  overlays,
  onEdit
}) => overlays ? overlays.openConfirm(_i18n.i18n.translate('indexPatternEditor.editDataView.editConfirmationModal.modalDescription', {
  defaultMessage: 'Changing this data view can break other objects that depend on it.'
}), {
  confirmButtonText: _i18n.i18n.translate('indexPatternEditor.editDataView.editConfirmationModal.confirmButton', {
    defaultMessage: 'Confirm'
  }),
  title: _i18n.i18n.translate('indexPatternEditor.editDataView.editConfirmationModal.editHeader', {
    defaultMessage: `Edit ''{name}''`,
    values: {
      name: dataViewName
    }
  }),
  buttonColor: 'danger'
}).then(async isConfirmed => {
  if (isConfirmed) {
    await onEdit();
  }
}) : Promise.resolve();
exports.editDataViewModal = editDataViewModal;