"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KIBANA_FEATURE = exports.ELASTICSEARCH_FEATURE = void 0;
var _coreApplicationCommon = require("@kbn/core-application-common");
var _common = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KIBANA_FEATURE = exports.KIBANA_FEATURE = {
  id: _common.PLUGIN_FEATURE_ID,
  name: _common.PLUGIN_NAME,
  category: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.management,
  app: [_common.PLUGIN_ID],
  privileges: {
    all: {
      app: [_common.PLUGIN_ID],
      savedObject: {
        all: [],
        read: []
      },
      ui: ['show']
    },
    read: {
      disabled: true,
      savedObject: {
        all: [],
        read: []
      },
      ui: ['show']
    }
  }
};
const ELASTICSEARCH_FEATURE = exports.ELASTICSEARCH_FEATURE = {
  id: _common.PLUGIN_ID,
  management: {
    data: [_common.PLUGIN_ID]
  },
  privileges: [{
    ui: [],
    requiredClusterPrivileges: [],
    requiredIndexPrivileges: {
      ['logs-*-*']: ['read']
    }
  }, {
    ui: [],
    requiredClusterPrivileges: [],
    requiredIndexPrivileges: {
      ['traces-*-*']: ['read']
    }
  }, {
    ui: [],
    requiredClusterPrivileges: [],
    requiredIndexPrivileges: {
      ['metrics-*-*']: ['read']
    }
  }, {
    ui: [],
    requiredClusterPrivileges: [],
    requiredIndexPrivileges: {
      ['synthetics-*-*']: ['read']
    }
  }]
};