"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timeRangeRT = exports.tableRT = exports.sortRT = exports.qualityIssuesRT = exports.directionRT = exports.degradedFieldRT = exports.dataStreamRT = exports.DATA_QUALITY_URL_STATE_KEY = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DATA_QUALITY_URL_STATE_KEY = exports.DATA_QUALITY_URL_STATE_KEY = 'pageState';
const qualityIssuesRT = exports.qualityIssuesRT = rt.keyof({
  degraded: null,
  failed: null
});
const directionRT = exports.directionRT = rt.keyof({
  asc: null,
  desc: null
});
const sortRT = exports.sortRT = rt.strict({
  field: rt.string,
  direction: directionRT
});
const tableRT = exports.tableRT = rt.exact(rt.partial({
  page: rt.number,
  rowsPerPage: rt.number,
  sort: sortRT
}));
const timeRangeRT = exports.timeRangeRT = rt.strict({
  from: rt.string,
  to: rt.string,
  refresh: rt.strict({
    pause: rt.boolean,
    value: rt.number
  })
});
const degradedFieldRT = exports.degradedFieldRT = rt.exact(rt.partial({
  table: tableRT
}));
const dataStreamRT = exports.dataStreamRT = new rt.Type('dataStreamRT', input => typeof input === 'string' && (input.match(/-/g) || []).length >= 2, (input, context) => typeof input === 'string' && (input.match(/-/g) || []).length >= 2 ? rt.success(input) : rt.failure(input, context), rt.identity);