"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.constructDatasetQualityDetailsLocatorPath = void 0;
var _common = require("@kbn/kibana-utils-plugin/common");
var _url_schema = require("../url_schema");
var _deep_compact_object = require("../utils/deep_compact_object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const constructDatasetQualityDetailsLocatorPath = async params => {
  const {
    locatorParams,
    useHash,
    managementLocator
  } = params;
  const pageState = _url_schema.datasetQualityDetailsUrlSchemaV1.urlSchemaRT.encode((0, _deep_compact_object.deepCompactObject)({
    v: 1,
    ...locatorParams
  }));
  const managementPath = await managementLocator.getLocation({
    sectionId: 'data',
    appId: 'data_quality/details'
  });
  const path = (0, _common.setStateToKbnUrl)(_url_schema.DATA_QUALITY_URL_STATE_KEY, pageState, {
    useHash,
    storeInHashQuery: false
  }, `${managementPath.app}${managementPath.path}`);
  return {
    app: '',
    path,
    state: {}
  };
};
exports.constructDatasetQualityDetailsLocatorPath = constructDatasetQualityDetailsLocatorPath;