"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRenameActionDescriptor = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _reactKibanaMount = require("@kbn/react-kibana-mount");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const RenameDialog = ({
  onActionDismiss,
  ...props
}) => {
  const {
    api,
    searchSession
  } = props;
  const {
    id,
    name: originalName
  } = searchSession;
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [newName, setNewName] = (0, _react.useState)(originalName);
  const title = _i18n.i18n.translate('data.mgmt.searchSessions.renameModal.title', {
    defaultMessage: 'Edit search session name'
  });
  const confirm = _i18n.i18n.translate('data.mgmt.searchSessions.renameModal.renameButton', {
    defaultMessage: 'Save'
  });
  const cancel = _i18n.i18n.translate('data.mgmt.searchSessions.renameModal.cancelButton', {
    defaultMessage: 'Cancel'
  });
  const label = _i18n.i18n.translate('data.mgmt.searchSessions.renameModal.searchSessionNameInputLabel', {
    defaultMessage: 'Search session name'
  });
  const isNewNameValid = newName && originalName !== newName;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onActionDismiss,
    initialFocus: "[name=newName]"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "newName",
    placeholder: originalName,
    value: newName,
    onChange: e => setNewName(e.target.value)
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onActionDismiss,
    "data-test-subj": "cancelEditName"
  }, cancel), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: !isNewNameValid,
    onClick: async () => {
      if (!isNewNameValid) return;
      setIsLoading(true);
      await api.sendRename(id, newName);
      setIsLoading(false);
      onActionDismiss();
    },
    fill: true,
    isLoading: isLoading
  }, confirm)));
};
const createRenameActionDescriptor = (api, uiSession, core) => ({
  iconType: 'pencil',
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "data.mgmt.searchSessions.actionRename",
    defaultMessage: "Edit name"
  }),
  onClick: async () => {
    const ref = core.overlays.openModal((0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(RenameDialog, {
      onActionDismiss: () => ref === null || ref === void 0 ? void 0 : ref.close(),
      api: api,
      searchSession: uiSession
    }), core));
    await ref.onClose;
  }
});
exports.createRenameActionDescriptor = createRenameActionDescriptor;