"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeoutErrorMode = exports.SearchTimeoutError = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-utils-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
let TimeoutErrorMode = exports.TimeoutErrorMode = /*#__PURE__*/function (TimeoutErrorMode) {
  TimeoutErrorMode[TimeoutErrorMode["CONTACT"] = 0] = "CONTACT";
  TimeoutErrorMode[TimeoutErrorMode["CHANGE"] = 1] = "CHANGE";
  return TimeoutErrorMode;
}({});
/**
 * Request Failure - When an entire multi request fails
 * @param {Error} err - the Error that came back
 */
class SearchTimeoutError extends _common.KbnError {
  constructor(err, mode) {
    super(`Request timeout: ${JSON.stringify(err === null || err === void 0 ? void 0 : err.message)}`);
    (0, _defineProperty2.default)(this, "mode", void 0);
    this.mode = mode;
  }
  getMessage() {
    switch (this.mode) {
      case TimeoutErrorMode.CONTACT:
        return _i18n.i18n.translate('data.search.timeoutContactAdmin', {
          defaultMessage: 'Your query has timed out. Contact your system administrator to increase the run time.'
        });
      case TimeoutErrorMode.CHANGE:
        return _i18n.i18n.translate('data.search.timeoutIncreaseSetting', {
          defaultMessage: 'Your query has timed out. Increase run time with the search timeout advanced setting.'
        });
    }
  }
  getActionText() {
    switch (this.mode) {
      case TimeoutErrorMode.CHANGE:
        return _i18n.i18n.translate('data.search.timeoutIncreaseSettingActionText', {
          defaultMessage: 'Edit setting'
        });
        break;
    }
  }
  onClick(application) {
    switch (this.mode) {
      case TimeoutErrorMode.CHANGE:
        application.navigateToApp('management', {
          path: `/kibana/settings`
        });
        break;
    }
  }
  getErrorMessage(application) {
    const actionText = this.getActionText();
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, this.getMessage(), actionText && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      textAlign: "right"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "danger",
      onClick: () => this.onClick(application),
      size: "s",
      "data-test-subj": "searchTimeoutError"
    }, actionText))));
  }
}
exports.SearchTimeoutError = SearchTimeoutError;