"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimefilterService = void 0;
var _ = require(".");
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Filter Service
 * @internal
 */
class TimefilterService {
  constructor(nowProvider) {
    this.nowProvider = nowProvider;
  }
  setup({
    uiSettings,
    storage,
    minRefreshInterval
  }) {
    const timefilterConfig = {
      timeDefaults: uiSettings.get(_common.UI_SETTINGS.TIMEPICKER_TIME_DEFAULTS),
      refreshIntervalDefaults: uiSettings.get(_common.UI_SETTINGS.TIMEPICKER_REFRESH_INTERVAL_DEFAULTS),
      minRefreshIntervalDefault: minRefreshInterval
    };
    const history = new _.TimeHistory(storage);
    const timefilter = new _.Timefilter(timefilterConfig, history, this.nowProvider);
    return {
      timefilter,
      history
    };
  }
  start() {
    // nothing to do here yet
  }
  stop() {
    // nothing to do here yet
  }
}

/** @public */
exports.TimefilterService = TimefilterService;