"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPhrasesDisplayValue = getPhrasesDisplayValue;
exports.mapPhrases = void 0;
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getPhrasesDisplayValue(filter, formatter) {
  return filter.meta.params.map(v => {
    var _formatter$convert;
    return (_formatter$convert = formatter === null || formatter === void 0 ? void 0 : formatter.convert(v)) !== null && _formatter$convert !== void 0 ? _formatter$convert : v;
  }).join(', ');
}
const mapPhrases = filter => {
  if (!(0, _esQuery.isPhrasesFilter)(filter)) {
    throw filter;
  }
  const {
    type,
    key,
    params
  } = filter.meta;
  return {
    type,
    key,
    value: params,
    params
  };
};
exports.mapPhrases = mapPhrases;