"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ACTION_SELECT_RANGE = void 0;
exports.createSelectRangeActionDefinition = createSelectRangeActionDefinition;
var _triggers = require("../triggers");
var _create_filters_from_range_select = require("./filters/create_filters_from_range_select");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ACTION_SELECT_RANGE = exports.ACTION_SELECT_RANGE = 'ACTION_SELECT_RANGE';
function createSelectRangeActionDefinition(getStartServices) {
  return {
    type: ACTION_SELECT_RANGE,
    id: ACTION_SELECT_RANGE,
    shouldAutoExecute: async () => true,
    execute: async context => {
      try {
        const filters = await (0, _create_filters_from_range_select.createFiltersFromRangeSelectAction)(context.data);
        if (filters.length > 0) {
          await getStartServices().uiActions.getTrigger(_triggers.APPLY_FILTER_TRIGGER).exec({
            filters,
            embeddable: context.embeddable,
            timeFieldName: context.data.timeFieldName
          });
        }
      } catch (e) {
        // eslint-disable-next-line no-console
        console.warn(`Error [ACTION_SELECT_RANGE]: can\'t extract filters from action context`);
      }
    }
  };
}