"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ACTION_MULTI_VALUE_CLICK = void 0;
exports.createMultiValueClickActionDefinition = createMultiValueClickActionDefinition;
var _esQuery = require("@kbn/es-query");
var _create_filters_from_multi_value_click = require("./filters/create_filters_from_multi_value_click");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ACTION_MULTI_VALUE_CLICK = exports.ACTION_MULTI_VALUE_CLICK = 'ACTION_MULTI_VALUE_CLICK';
function createMultiValueClickActionDefinition(getStartServices) {
  return {
    type: ACTION_MULTI_VALUE_CLICK,
    id: ACTION_MULTI_VALUE_CLICK,
    shouldAutoExecute: async () => true,
    isCompatible: async context => {
      const filters = await (0, _create_filters_from_multi_value_click.createFiltersFromMultiValueClickAction)(context.data);
      return Boolean(filters);
    },
    execute: async ({
      data
    }) => {
      const filters = await (0, _create_filters_from_multi_value_click.createFiltersFromMultiValueClickAction)(data);
      if (!filters || (filters === null || filters === void 0 ? void 0 : filters.length) === 0) return;
      const {
        filterManager,
        timefilter: {
          timefilter
        }
      } = getStartServices().query;
      if (data.timeFieldName) {
        const {
          timeRangeFilter,
          restOfFilters
        } = (0, _esQuery.extractTimeFilter)(data.timeFieldName, filters);
        filterManager.addFilters(restOfFilters);
        if (timeRangeFilter) {
          timefilter.setTime((0, _esQuery.convertRangeFilterToTimeRange)(timeRangeFilter));
        }
      } else {
        filterManager.addFilters(filters);
      }
    }
  };
}