"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimeSeriesBucketAgg = void 0;
Object.defineProperty(exports, "termsAggFilter", {
  enumerable: true,
  get: function () {
    return _terms_order_helper.termsAggFilter;
  }
});
var _i18n = require("@kbn/i18n");
var _bucket_agg_type = require("./bucket_agg_type");
var _bucket_agg_types = require("./bucket_agg_types");
var _time_series_fn = require("./time_series_fn");
var _terms_order_helper = require("./_terms_order_helper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const timeSeriesTitle = _i18n.i18n.translate('data.search.aggs.buckets.timeSeriesTitle', {
  defaultMessage: 'Time Series'
});
const getTimeSeriesBucketAgg = () => new _bucket_agg_type.BucketAggType({
  name: _bucket_agg_types.BUCKET_TYPES.TIME_SERIES,
  expressionName: _time_series_fn.aggTimeSeriesFnName,
  title: timeSeriesTitle,
  params: []
});
exports.getTimeSeriesBucketAgg = getTimeSeriesBucketAgg;