"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertPanelStateToSavedDashboardPanel = convertPanelStateToSavedDashboardPanel;
exports.convertSavedDashboardPanelToPanelState = convertSavedDashboardPanelToPanelState;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function convertSavedDashboardPanelToPanelState(savedDashboardPanel) {
  return {
    type: savedDashboardPanel.type,
    gridData: savedDashboardPanel.gridData,
    panelRefName: savedDashboardPanel.panelRefName,
    explicitInput: {
      id: savedDashboardPanel.panelIndex,
      ...(savedDashboardPanel.id !== undefined && {
        savedObjectId: savedDashboardPanel.id
      }),
      ...(savedDashboardPanel.title !== undefined && {
        title: savedDashboardPanel.title
      }),
      ...savedDashboardPanel.embeddableConfig
    },
    version: savedDashboardPanel.version
  };
}
function convertPanelStateToSavedDashboardPanel(panelState) {
  const savedObjectId = panelState.explicitInput.savedObjectId;
  const panelIndex = panelState.explicitInput.id;
  return {
    type: panelState.type,
    gridData: {
      ...panelState.gridData,
      i: panelIndex
    },
    panelIndex,
    embeddableConfig: (0, _lodash.omit)(panelState.explicitInput, ['id', 'savedObjectId', 'title']),
    ...(panelState.explicitInput.title !== undefined && {
      title: panelState.explicitInput.title
    }),
    ...(savedObjectId !== undefined && {
      id: savedObjectId
    }),
    ...(panelState.panelRefName !== undefined && {
      panelRefName: panelState.panelRefName
    }),
    ...(panelState.version !== undefined && {
      version: panelState.version
    })
  };
}