"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.newSession$ = newSession$;
var _esQuery = require("@kbn/es-query");
var _rxjs = require("rxjs");
var _publishes_settings = require("@kbn/presentation-containers/interfaces/publishes_settings");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _unified_search_manager = require("../../../../dashboard_api/unified_search_manager");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const shouldRefreshFilterCompareOptions = {
  ..._esQuery.COMPARE_ALL_OPTIONS,
  // do not compare $state to avoid refreshing when filter is pinned/unpinned (which does not impact results)
  state: false
};
function newSession$(api) {
  const observables = [];
  if ((0, _presentationPublishing.apiPublishesUnifiedSearch)(api)) {
    observables.push(api.filters$.pipe((0, _rxjs.distinctUntilChanged)((previous, current) => {
      return (0, _esQuery.onlyDisabledFiltersChanged)(previous, current, shouldRefreshFilterCompareOptions);
    })));
    observables.push(api.query$);
    observables.push(api.timeRange$.pipe((0, _rxjs.distinctUntilChanged)((previous, current) => {
      return (0, _unified_search_manager.areTimesEqual)(current === null || current === void 0 ? void 0 : current.from, previous === null || previous === void 0 ? void 0 : previous.from) && (0, _unified_search_manager.areTimesEqual)(current === null || current === void 0 ? void 0 : current.to, previous === null || previous === void 0 ? void 0 : previous.to);
    })));
    if (api.timeRestore$) {
      observables.push(api.timeRestore$);
    }
    if (api.timeslice$) {
      observables.push(api.timeslice$);
    }
  }
  if ((0, _publishes_settings.apiPublishesSettings)(api)) {
    if (api.settings.syncColors$) {
      observables.push(api.settings.syncColors$);
    }
    if (api.settings.syncCursor$) {
      observables.push(api.settings.syncCursor$);
    }
    if (api.settings.syncTooltips$) {
      observables.push(api.settings.syncTooltips$);
    }
  }
  if ((0, _presentationPublishing.apiPublishesReload)(api)) {
    observables.push(api.reload$);
  }
  return (0, _rxjs.combineLatest)(observables).pipe((0, _rxjs.skip)(1));
}