"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDashboardMenuItems = void 0;
var _react = require("react");
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _presentationPublishing = require("@kbn/presentation-publishing");
var _common = require("../../../common");
var _use_dashboard_api = require("../../dashboard_api/use_dashboard_api");
var _api = require("../../dashboard_container/embeddable/api");
var _confirm_overlays = require("../../dashboard_listing/confirm_overlays");
var _dashboard_backup_service = require("../../services/dashboard_backup_service");
var _kibana_services = require("../../services/kibana_services");
var _get_dashboard_capabilities = require("../../utils/get_dashboard_capabilities");
var _dashboard_app_strings = require("../_dashboard_app_strings");
var _show_share_modal = require("./share/show_share_modal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const useDashboardMenuItems = ({
  isLabsShown,
  setIsLabsShown,
  maybeRedirect,
  showResetChange
}) => {
  const isMounted = (0, _useMountedState.default)();
  const [isSaveInProgress, setIsSaveInProgress] = (0, _react.useState)(false);
  const dashboardApi = (0, _use_dashboard_api.useDashboardApi)();
  const [dashboardTitle, hasOverlays, hasUnsavedChanges, lastSavedId, viewMode] = (0, _presentationPublishing.useBatchedPublishingSubjects)(dashboardApi.title$, dashboardApi.hasOverlays$, dashboardApi.hasUnsavedChanges$, dashboardApi.savedObjectId$, dashboardApi.viewMode$);
  const disableTopNav = isSaveInProgress || hasOverlays;

  /**
   * Show the Dashboard app's share menu
   */
  const showShare = (0, _react.useCallback)(anchorElement => {
    (0, _show_share_modal.ShowShareModal)({
      dashboardTitle,
      anchorElement,
      savedObjectId: lastSavedId,
      isDirty: Boolean(hasUnsavedChanges),
      getPanelsState: () => dashboardApi.panels$.value
    });
  }, [dashboardTitle, hasUnsavedChanges, lastSavedId, dashboardApi]);

  /**
   * Save the dashboard without any UI or popups.
   */
  const quickSaveDashboard = (0, _react.useCallback)(() => {
    setIsSaveInProgress(true);
    dashboardApi.runQuickSave().then(() => setTimeout(() => setIsSaveInProgress(false), 100));
  }, [dashboardApi]);

  /**
   * initiate interactive dashboard copy action
   */
  const dashboardInteractiveSave = (0, _react.useCallback)(() => {
    dashboardApi.runInteractiveSave().then(result => maybeRedirect(result));
  }, [maybeRedirect, dashboardApi]);

  /**
   * Show the dashboard's "Confirm reset changes" modal. If confirmed:
   * (1) reset the dashboard to the last saved state, and
   * (2) if `switchToViewMode` is `true`, set the dashboard to view mode.
   */
  const [isResetting, setIsResetting] = (0, _react.useState)(false);
  const resetChanges = (0, _react.useCallback)((switchToViewMode = false) => {
    dashboardApi.clearOverlays();
    const switchModes = switchToViewMode ? () => {
      dashboardApi.setViewMode('view');
      (0, _dashboard_backup_service.getDashboardBackupService)().storeViewMode('view');
    } : undefined;
    if (!hasUnsavedChanges) {
      switchModes === null || switchModes === void 0 ? void 0 : switchModes();
      return;
    }
    (0, _confirm_overlays.confirmDiscardUnsavedChanges)(async () => {
      setIsResetting(true);
      await dashboardApi.asyncResetToLastSavedState();
      if (isMounted()) {
        setIsResetting(false);
        switchModes === null || switchModes === void 0 ? void 0 : switchModes();
      }
    }, viewMode);
  }, [dashboardApi, hasUnsavedChanges, viewMode, isMounted]);

  /**
   * Register all of the top nav configs that can be used by dashboard.
   */

  const menuItems = (0, _react.useMemo)(() => {
    return {
      fullScreen: {
        ..._dashboard_app_strings.topNavStrings.fullScreen,
        id: 'full-screen',
        testId: 'dashboardFullScreenMode',
        run: () => dashboardApi.setFullScreenMode(true),
        disableButton: disableTopNav
      },
      labs: {
        ..._dashboard_app_strings.topNavStrings.labs,
        id: 'labs',
        testId: 'dashboardLabs',
        run: () => setIsLabsShown(!isLabsShown)
      },
      edit: {
        ..._dashboard_app_strings.topNavStrings.edit,
        emphasize: true,
        id: 'edit',
        iconType: 'pencil',
        testId: 'dashboardEditMode',
        className: 'eui-hideFor--s eui-hideFor--xs',
        // hide for small screens - editing doesn't work in mobile mode.
        run: () => {
          (0, _dashboard_backup_service.getDashboardBackupService)().storeViewMode('edit');
          dashboardApi.setViewMode('edit');
          dashboardApi.clearOverlays();
        },
        disableButton: disableTopNav
      },
      quickSave: {
        ..._dashboard_app_strings.topNavStrings.quickSave,
        id: 'quick-save',
        iconType: 'save',
        emphasize: true,
        isLoading: isSaveInProgress,
        testId: 'dashboardQuickSaveMenuItem',
        disableButton: disableTopNav || !hasUnsavedChanges,
        run: () => quickSaveDashboard()
      },
      interactiveSave: {
        disableButton: disableTopNav,
        emphasize: !Boolean(lastSavedId),
        id: 'interactive-save',
        testId: 'dashboardInteractiveSaveMenuItem',
        run: dashboardInteractiveSave,
        label: viewMode === 'view' ? _dashboard_app_strings.topNavStrings.viewModeInteractiveSave.label : Boolean(lastSavedId) ? _dashboard_app_strings.topNavStrings.editModeInteractiveSave.label : _dashboard_app_strings.topNavStrings.quickSave.label,
        description: viewMode === 'view' ? _dashboard_app_strings.topNavStrings.viewModeInteractiveSave.description : _dashboard_app_strings.topNavStrings.editModeInteractiveSave.description
      },
      switchToViewMode: {
        ..._dashboard_app_strings.topNavStrings.switchToViewMode,
        id: 'cancel',
        disableButton: disableTopNav || !lastSavedId || isResetting,
        isLoading: isResetting,
        testId: 'dashboardViewOnlyMode',
        run: () => resetChanges(true)
      },
      share: {
        ..._dashboard_app_strings.topNavStrings.share,
        id: 'share',
        testId: 'shareTopNavButton',
        disableButton: disableTopNav,
        run: showShare
      },
      settings: {
        ..._dashboard_app_strings.topNavStrings.settings,
        id: 'settings',
        testId: 'dashboardSettingsButton',
        disableButton: disableTopNav,
        run: () => (0, _api.openSettingsFlyout)(dashboardApi)
      }
    };
  }, [disableTopNav, isSaveInProgress, hasUnsavedChanges, lastSavedId, dashboardInteractiveSave, viewMode, showShare, dashboardApi, setIsLabsShown, isLabsShown, quickSaveDashboard, resetChanges, isResetting]);
  const resetChangesMenuItem = (0, _react.useMemo)(() => {
    return {
      ..._dashboard_app_strings.topNavStrings.resetChanges,
      id: 'reset',
      testId: 'dashboardDiscardChangesMenuItem',
      disableButton: isResetting || !hasUnsavedChanges || hasOverlays || viewMode === 'edit' && (isSaveInProgress || !lastSavedId),
      isLoading: isResetting,
      run: () => resetChanges()
    };
  }, [hasOverlays, lastSavedId, resetChanges, viewMode, isSaveInProgress, hasUnsavedChanges, isResetting]);

  /**
   * Build ordered menus for view and edit mode.
   */
  const isLabsEnabled = (0, _react.useMemo)(() => _kibana_services.coreServices.uiSettings.get(_common.UI_SETTINGS.ENABLE_LABS_UI), []);
  const viewModeTopNavConfig = (0, _react.useMemo)(() => {
    const {
      showWriteControls
    } = (0, _get_dashboard_capabilities.getDashboardCapabilities)();
    const labsMenuItem = isLabsEnabled ? [menuItems.labs] : [];
    const shareMenuItem = _kibana_services.shareService ? [menuItems.share] : [];
    const duplicateMenuItem = showWriteControls ? [menuItems.interactiveSave] : [];
    const editMenuItem = showWriteControls && !dashboardApi.isManaged ? [menuItems.edit] : [];
    const mayberesetChangesMenuItem = showResetChange ? [resetChangesMenuItem] : [];
    return [...labsMenuItem, menuItems.fullScreen, ...shareMenuItem, ...duplicateMenuItem, ...mayberesetChangesMenuItem, ...editMenuItem];
  }, [isLabsEnabled, menuItems, dashboardApi.isManaged, showResetChange, resetChangesMenuItem]);
  const editModeTopNavConfig = (0, _react.useMemo)(() => {
    const labsMenuItem = isLabsEnabled ? [menuItems.labs] : [];
    const shareMenuItem = _kibana_services.shareService ? [menuItems.share] : [];
    const editModeItems = [];
    if (lastSavedId) {
      editModeItems.push(menuItems.interactiveSave, menuItems.switchToViewMode);
      if (showResetChange) {
        editModeItems.push(resetChangesMenuItem);
      }
      editModeItems.push(menuItems.quickSave);
    } else {
      editModeItems.push(menuItems.switchToViewMode, menuItems.interactiveSave);
    }
    return [...labsMenuItem, menuItems.settings, ...shareMenuItem, ...editModeItems];
  }, [isLabsEnabled, menuItems, lastSavedId, showResetChange, resetChangesMenuItem]);
  return {
    viewModeTopNavConfig,
    editModeTopNavConfig
  };
};
exports.useDashboardMenuItems = useDashboardMenuItems;