"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadDashboardApi = loadDashboardApi;
var _contentManagementContentInsightsPublic = require("@kbn/content-management-content-insights-public");
var _dashboard_content_management_service = require("../services/dashboard_content_management_service");
var _get_dashboard_api = require("./get_dashboard_api");
var _query_performance_tracking = require("../dashboard_container/embeddable/create/performance/query_performance_tracking");
var _kibana_services = require("../services/kibana_services");
var _logger = require("../services/logger");
var _dashboard_backup_service = require("../services/dashboard_backup_service");
var _default_dashboard_input = require("./default_dashboard_input");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function loadDashboardApi({
  getCreationOptions,
  savedObjectId
}) {
  var _creationOptions$getI, _creationOptions$vali, _dashboardBackupState, _savedObjectResult$da, _sessionStorageInput$, _creationOptions$getI2;
  const creationStartTime = performance.now();
  const creationOptions = await (getCreationOptions === null || getCreationOptions === void 0 ? void 0 : getCreationOptions());
  const incomingEmbeddable = creationOptions === null || creationOptions === void 0 ? void 0 : (_creationOptions$getI = creationOptions.getIncomingEmbeddable) === null || _creationOptions$getI === void 0 ? void 0 : _creationOptions$getI.call(creationOptions);
  const savedObjectResult = await (0, _dashboard_content_management_service.getDashboardContentManagementService)().loadDashboardState({
    id: savedObjectId
  });

  // --------------------------------------------------------------------------------------
  // Run validation.
  // --------------------------------------------------------------------------------------
  const validationResult = savedObjectResult && (creationOptions === null || creationOptions === void 0 ? void 0 : (_creationOptions$vali = creationOptions.validateLoadedSavedObject) === null || _creationOptions$vali === void 0 ? void 0 : _creationOptions$vali.call(creationOptions, savedObjectResult));
  if (validationResult === 'invalid') {
    // throw error to stop the rest of Dashboard loading and make the factory throw an Error
    throw new Error('Dashboard failed saved object result validation');
  } else if (validationResult === 'redirected') {
    return;
  }

  // --------------------------------------------------------------------------------------
  // Combine saved object state and session storage state
  // --------------------------------------------------------------------------------------
  const dashboardBackupState = (0, _dashboard_backup_service.getDashboardBackupService)().getState(savedObjectResult.dashboardId);
  const initialPanelsRuntimeState = creationOptions !== null && creationOptions !== void 0 && creationOptions.useSessionStorageIntegration ? (_dashboardBackupState = dashboardBackupState === null || dashboardBackupState === void 0 ? void 0 : dashboardBackupState.panels) !== null && _dashboardBackupState !== void 0 ? _dashboardBackupState : {} : {};
  const sessionStorageInput = (() => {
    if (!(creationOptions !== null && creationOptions !== void 0 && creationOptions.useSessionStorageIntegration)) return;
    return dashboardBackupState === null || dashboardBackupState === void 0 ? void 0 : dashboardBackupState.dashboardState;
  })();
  const combinedSessionState = {
    ..._default_dashboard_input.DEFAULT_DASHBOARD_INPUT,
    ...((_savedObjectResult$da = savedObjectResult === null || savedObjectResult === void 0 ? void 0 : savedObjectResult.dashboardInput) !== null && _savedObjectResult$da !== void 0 ? _savedObjectResult$da : {}),
    ...sessionStorageInput
  };
  combinedSessionState.references = sessionStorageInput !== null && sessionStorageInput !== void 0 && (_sessionStorageInput$ = sessionStorageInput.references) !== null && _sessionStorageInput$ !== void 0 && _sessionStorageInput$.length ? sessionStorageInput === null || sessionStorageInput === void 0 ? void 0 : sessionStorageInput.references : savedObjectResult === null || savedObjectResult === void 0 ? void 0 : savedObjectResult.references;

  // --------------------------------------------------------------------------------------
  // Combine state with overrides.
  // --------------------------------------------------------------------------------------
  const overrideState = creationOptions === null || creationOptions === void 0 ? void 0 : (_creationOptions$getI2 = creationOptions.getInitialInput) === null || _creationOptions$getI2 === void 0 ? void 0 : _creationOptions$getI2.call(creationOptions);
  if (overrideState !== null && overrideState !== void 0 && overrideState.panels) {
    const overridePanels = {};
    for (const panel of Object.values(overrideState === null || overrideState === void 0 ? void 0 : overrideState.panels)) {
      var _combinedSessionState;
      overridePanels[panel.explicitInput.id] = {
        ...panel,
        /**
         * here we need to keep the state of the panel that was already in the Dashboard if one exists.
         * This is because this state will become the "last saved state" for this panel.
         */
        ...((_combinedSessionState = combinedSessionState.panels[panel.explicitInput.id]) !== null && _combinedSessionState !== void 0 ? _combinedSessionState : [])
      };
      /**
       * We also need to add the state of this react embeddable into the runtime state to be restored.
       */
      initialPanelsRuntimeState[panel.explicitInput.id] = panel.explicitInput;
    }
    overrideState.panels = overridePanels;
  }
  // Back up any view mode passed in explicitly.
  if (overrideState !== null && overrideState !== void 0 && overrideState.viewMode) {
    (0, _dashboard_backup_service.getDashboardBackupService)().storeViewMode(overrideState === null || overrideState === void 0 ? void 0 : overrideState.viewMode);
  }
  if (overrideState !== null && overrideState !== void 0 && overrideState.controlGroupState) {
    initialPanelsRuntimeState[_dashboard_backup_service.PANELS_CONTROL_GROUP_KEY] = overrideState.controlGroupState;
  }

  // --------------------------------------------------------------------------------------
  // get dashboard Api
  // --------------------------------------------------------------------------------------
  const {
    api,
    cleanup,
    internalApi
  } = (0, _get_dashboard_api.getDashboardApi)({
    creationOptions,
    incomingEmbeddable,
    initialState: {
      ...combinedSessionState,
      ...overrideState
    },
    initialPanelsRuntimeState,
    savedObjectResult,
    savedObjectId
  });
  const performanceSubscription = (0, _query_performance_tracking.startQueryPerformanceTracking)(api, {
    firstLoad: true,
    creationStartTime
  });
  if (savedObjectId && !incomingEmbeddable) {
    // We count a new view every time a user opens a dashboard, both in view or edit mode
    // We don't count views when a user is editing a dashboard and is returning from an editor after saving
    // however, there is an edge case that we now count a new view when a user is editing a dashboard and is returning from an editor by canceling
    // TODO: this should be revisited by making embeddable transfer support canceling logic https://github.com/elastic/kibana/issues/190485
    const contentInsightsClient = new _contentManagementContentInsightsPublic.ContentInsightsClient({
      http: _kibana_services.coreServices.http,
      logger: _logger.logger
    }, {
      domainId: 'dashboard'
    });
    contentInsightsClient.track(savedObjectId, 'viewed');
  }
  return {
    api,
    cleanup: () => {
      cleanup();
      performanceSubscription.unsubscribe();
    },
    internalApi
  };
}