"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutoFollowPatternAdd = void 0;
var _reactRedux = require("react-redux");
var _constants = require("../../constants");
var _selectors = require("../../store/selectors");
var _actions = require("../../store/actions");
var _auto_follow_pattern_add = require("./auto_follow_pattern_add");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const scope = _constants.SECTIONS.AUTO_FOLLOW_PATTERN;
const mapStateToProps = state => ({
  apiStatus: (0, _selectors.getApiStatus)(`${scope}-save`)(state),
  apiError: (0, _selectors.getApiError)(`${scope}-save`)(state)
});
const mapDispatchToProps = dispatch => ({
  saveAutoFollowPattern: (id, autoFollowPattern) => dispatch((0, _actions.saveAutoFollowPattern)(id, autoFollowPattern)),
  clearApiError: () => dispatch((0, _actions.clearApiError)(scope))
});
const AutoFollowPatternAdd = exports.AutoFollowPatternAdd = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_auto_follow_pattern_add.AutoFollowPatternAdd);