"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecurityService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _fips = require("./fips/fips");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class SecurityService {
  constructor(coreContext) {
    (0, _defineProperty2.default)(this, "log", void 0);
    (0, _defineProperty2.default)(this, "securityApi", void 0);
    (0, _defineProperty2.default)(this, "config$", void 0);
    (0, _defineProperty2.default)(this, "configSubscription", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "getConfig", () => {
      if (!this.config) {
        throw new Error('Config is not available.');
      }
      return this.config;
    });
    this.log = coreContext.logger.get('security-service');
    this.config$ = coreContext.configService.getConfig$();
    this.configSubscription = this.config$.subscribe(config => {
      this.config = config;
    });
  }
  setup() {
    const config = this.getConfig();
    const securityConfig = config.get(['xpack', 'security']);
    const elasticsearchConfig = config.get(['elasticsearch']);
    const serverConfig = config.get(['server']);
    (0, _fips.checkFipsConfig)(securityConfig, elasticsearchConfig, serverConfig, this.log);
    return {
      registerSecurityDelegate: api => {
        if (this.securityApi) {
          throw new Error('security API can only be registered once');
        }
        this.securityApi = api;
      },
      fips: {
        isEnabled: () => (0, _fips.isFipsEnabled)(securityConfig)
      }
    };
  }
  start() {
    var _this$securityApi;
    if (!this.securityApi) {
      this.log.warn('Security API was not registered, using default implementation');
    }
    const apiContract = (_this$securityApi = this.securityApi) !== null && _this$securityApi !== void 0 ? _this$securityApi : (0, _utils.getDefaultSecurityImplementation)();
    return (0, _utils.convertSecurityApi)(apiContract);
  }
  stop() {
    if (this.configSubscription) {
      this.configSubscription.unsubscribe();
      this.configSubscription = undefined;
    }
  }
}
exports.SecurityService = SecurityService;