"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateExcludeFilters = void 0;
var _std = require("@kbn/std");
var Either = _interopRequireWildcard(require("fp-ts/lib/Either"));
var _catch_retryable_es_client_errors = require("./catch_retryable_es_client_errors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const calculateExcludeFilters = ({
  client,
  excludeFromUpgradeFilterHooks,
  hookTimeoutMs = 30_000 // default to 30s, exposed for testing
}) => () => {
  return Promise.all(Object.entries(excludeFromUpgradeFilterHooks).map(([soType, hook]) => (0, _std.withTimeout)({
    promise: Promise.resolve(hook({
      readonlyEsClient: {
        search: client.search.bind(client)
      }
    })),
    timeoutMs: hookTimeoutMs
  }).then(result => result.timedout ? Either.left({
    soType,
    error: new Error(`excludeFromUpgrade hook timed out after ${hookTimeoutMs / 1000} seconds.`)
  }) : Either.right(result.value)).catch(error => {
    const retryableError = (0, _catch_retryable_es_client_errors.catchRetryableEsClientErrors)(error);
    if (Either.isLeft(retryableError)) {
      return Either.left({
        soType,
        error: retryableError.left
      });
    } else {
      // Really should never happen, only here to satisfy TypeScript
      return Either.left({
        soType,
        error: new Error(`Unexpected return value from catchRetryableEsClientErrors: "${retryableError.toString()}"`)
      });
    }
  }).catch(error => Either.left({
    soType,
    error
  })))).then(results => {
    const retryableError = results.find(r => Either.isLeft(r) && !(r.left.error instanceof Error) && r.left.error.type === 'retryable_es_client_error');
    if (retryableError) {
      return Either.left(retryableError.left.error);
    }
    const errorsByType = [];
    const filterClauses = [];

    // Loop through all results and collect successes and errors
    results.forEach(r => Either.isRight(r) ? filterClauses.push(r.right) : Either.isLeft(r) && errorsByType.push([r.left.soType, r.left.error]));
    return Either.right({
      filterClauses,
      errorsByType: Object.fromEntries(errorsByType)
    });
  });
};
exports.calculateExcludeFilters = calculateExcludeFilters;