"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.performResolve = void 0;
var _internal_bulk_resolve = require("./internals/internal_bulk_resolve");
var _increment_counter_internal = require("./internals/increment_counter_internal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const performResolve = async ({
  type,
  id,
  options
}, apiExecutionContext) => {
  const {
    common: commonHelper
  } = apiExecutionContext.helpers;
  const namespace = commonHelper.getCurrentNamespace(options.namespace);
  const {
    resolved_objects: bulkResults
  } = await (0, _internal_bulk_resolve.internalBulkResolve)({
    objects: [{
      type,
      id
    }],
    options: {
      ...options,
      namespace
    },
    incrementCounterInternal: (t, i, counterFields, opts = {}) => (0, _increment_counter_internal.incrementCounterInternal)({
      type: t,
      id: i,
      counterFields,
      options: opts
    }, apiExecutionContext)
  }, apiExecutionContext);
  const [result] = bulkResults;
  if ((0, _internal_bulk_resolve.isBulkResolveError)(result)) {
    throw result.error;
  }
  return result;
};
exports.performResolve = performResolve;