"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RenderingService = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _rxjs = require("rxjs");
var _reactKibanaContextRoot = require("@kbn/react-kibana-context-root");
var _coreRenderingBrowser = require("@kbn/core-rendering-browser");
var _app_containers = require("./app_containers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Renders all Core UI in a single React tree.
 *
 * @internalRemarks Currently this only renders Chrome UI. Notifications and
 * Overlays UI should be moved here as well.
 *
 * @internal
 */
class RenderingService {
  start({
    application,
    chrome,
    overlays,
    targetDomElement,
    ...startServices
  }) {
    const chromeHeader = chrome.getHeaderComponent();
    const appComponent = application.getComponent();
    const bannerComponent = overlays.banners.getComponent();
    const body = document.querySelector('body');
    chrome.getBodyClasses$().pipe((0, _rxjs.startWith)([]), (0, _rxjs.pairwise)()).subscribe(([previousClasses, newClasses]) => {
      body.classList.remove(...previousClasses);
      body.classList.add(...newClasses);
    });
    _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_reactKibanaContextRoot.KibanaRootContextProvider, (0, _extends2.default)({}, startServices, {
      globalStyles: true
    }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, chromeHeader, /*#__PURE__*/_react.default.createElement("div", {
      id: "globalBannerList"
    }, bannerComponent), /*#__PURE__*/_react.default.createElement(_app_containers.AppWrapper, {
      chromeVisible$: chrome.getIsVisible$()
    }, /*#__PURE__*/_react.default.createElement("div", {
      id: _coreRenderingBrowser.APP_FIXED_VIEWPORT_ID
    }), appComponent))), targetDomElement);
  }
}
exports.RenderingService = RenderingService;