"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PriorityMap = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Immutable map that ensures entries are always in descending order based on
 * the values 'priority' property.
 */
class PriorityMap {
  constructor(map) {
    (0, _defineProperty2.default)(this, "map", void 0);
    this.map = map ? new Map(sortEntries(map)) : new Map();
  }
  add(key, value) {
    return new PriorityMap(new Map(sortEntries([...this.map, [key, value]])));
  }
  remove(key) {
    return new PriorityMap(new Map([...this.map].filter(([itemKey]) => itemKey !== key)));
  }
  has(key) {
    return this.map.has(key);
  }
  [Symbol.iterator]() {
    return this.map[Symbol.iterator]();
  }
  values() {
    return this.map.values();
  }
}
exports.PriorityMap = PriorityMap;
const sortEntries = map => (0, _lodash.sortBy)([...map], '1.priority').reverse();