"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _toasts = require("./toasts");
var _telemetry = require("./toasts/telemetry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @public */
class NotificationsService {
  constructor() {
    (0, _defineProperty2.default)(this, "toasts", void 0);
    (0, _defineProperty2.default)(this, "uiSettingsErrorSubscription", void 0);
    (0, _defineProperty2.default)(this, "targetDomElement", void 0);
    this.toasts = new _toasts.ToastsService();
  }
  setup({
    uiSettings,
    analytics
  }) {
    _telemetry.eventTypes.forEach(eventType => {
      analytics.registerEventType(eventType);
    });
    const notificationSetup = {
      toasts: this.toasts.setup({
        uiSettings
      })
    };
    this.uiSettingsErrorSubscription = uiSettings.getUpdateErrors$().subscribe(error => {
      notificationSetup.toasts.addDanger({
        title: _i18n.i18n.translate('core.notifications.unableUpdateUISettingNotificationMessageTitle', {
          defaultMessage: 'Unable to update UI setting'
        }),
        text: error.message
      });
    });
    return notificationSetup;
  }
  start({
    overlays,
    targetDomElement,
    ...startDeps
  }) {
    this.targetDomElement = targetDomElement;
    const toastsContainer = document.createElement('div');
    targetDomElement.appendChild(toastsContainer);
    const eventReporter = new _telemetry.EventReporter({
      analytics: startDeps.analytics
    });
    return {
      toasts: this.toasts.start({
        eventReporter,
        overlays,
        targetDomElement: toastsContainer,
        ...startDeps
      }),
      showErrorDialog: ({
        title,
        error
      }) => (0, _toasts.showErrorDialog)({
        title,
        error,
        openModal: overlays.openModal,
        ...startDeps
      })
    };
  }
  stop() {
    this.toasts.stop();
    if (this.targetDomElement) {
      this.targetDomElement.textContent = '';
    }
    if (this.uiSettingsErrorSubscription) {
      this.uiSettingsErrorSubscription.unsubscribe();
    }
  }
}

/**
 * @public {@link NotificationsService}
 */
exports.NotificationsService = NotificationsService;