"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mountReactNode = exports.MountWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactDom = require("react-dom");
var _i18nReact = require("@kbn/i18n-react");
require("./mount_wrapper.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const defaultWrapperClass = 'kbnMountWrapper';

/**
 * MountWrapper is a react component to mount a {@link MountPoint} inside a react tree.
 * @internal
 */

/**
 * MountWrapper is a react component to mount a {@link MountPoint} inside a react tree.
 * @internal
 */
const MountWrapper = ({
  mount,
  className = defaultWrapperClass
}) => {
  const element = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => mount(element.current), [mount]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: className,
    ref: element
  });
};

/**
 * Mount converter for react node.
 *
 * @param node to get a mount for
 * @internal
 */
exports.MountWrapper = MountWrapper;
const mountReactNode = node => element => {
  (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, node), element);
  return () => (0, _reactDom.unmountComponentAtNode)(element);
};
exports.mountReactNode = mountReactNode;