"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isCoreKibanaRequest = isCoreKibanaRequest;
exports.kibanaRequestFactory = kibanaRequestFactory;
var _coreHttpRouterServerInternal = require("@kbn/core-http-router-server-internal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Allows building a KibanaRequest from a RawRequest, leveraging internal CoreKibanaRequest.
 * @param req The raw request to build from
 * @param routeSchemas The route schemas
 * @param withoutSecretHeaders Whether we want to exclude secret headers
 * @returns A KibanaRequest object
 */
function kibanaRequestFactory(req, routeSchemas, withoutSecretHeaders = true) {
  return _coreHttpRouterServerInternal.CoreKibanaRequest.from(req, routeSchemas, withoutSecretHeaders);
}
function isCoreKibanaRequest(req) {
  return req instanceof _coreHttpRouterServerInternal.CoreKibanaRequest;
}