"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createHttpService = exports.createCoreContext = exports.createConfigService = void 0;
var _rxjs = require("rxjs");
var _moment = _interopRequireDefault(require("moment"));
var _repoInfo = require("@kbn/repo-info");
var _configSchema = require("@kbn/config-schema");
var _config = require("@kbn/config");
var _configMocks = require("@kbn/config-mocks");
var _coreLoggingServerMocks = require("@kbn/core-logging-server-mocks");
var _coreHttpServerInternal = require("@kbn/core-http-server-internal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const coreId = Symbol('core');
const env = _config.Env.createDefault(_repoInfo.REPO_ROOT, (0, _configMocks.getEnvOptions)());
const logger = _coreLoggingServerMocks.loggingSystemMock.create();
const createConfigService = ({
  server,
  externalUrl,
  csp
} = {}) => {
  const configService = _configMocks.configServiceMock.create();
  configService.atPath.mockImplementation(path => {
    if (path === 'server') {
      return new _rxjs.BehaviorSubject(Object.assign(_coreHttpServerInternal.config.schema.validate({}), {
        name: 'kibana',
        hosts: ['localhost'],
        maxPayload: new _configSchema.ByteSizeValue(1024),
        autoListen: true,
        ssl: {
          enabled: false
        },
        cors: {
          enabled: false
        },
        compression: {
          enabled: true,
          brotli: {
            enabled: false
          }
        },
        xsrf: {
          disableProtection: true,
          allowlist: []
        },
        securityResponseHeaders: {},
        customResponseHeaders: {},
        requestId: {
          allowFromAnyIp: true,
          ipAllowlist: []
        },
        shutdownTimeout: _moment.default.duration(30, 'seconds'),
        keepaliveTimeout: 120_000,
        socketTimeout: 120_000,
        restrictInternalApis: false,
        versioned: {
          versionResolution: 'oldest',
          strictClientVersionCheck: true
        }
      }, server));
    }
    if (path === 'externalUrl') {
      return new _rxjs.BehaviorSubject({
        policy: [],
        ...externalUrl
      });
    }
    if (path === 'csp') {
      return new _rxjs.BehaviorSubject({
        strict: false,
        disableEmbedding: false,
        warnLegacyBrowsers: true,
        ...csp
      });
    }
    if (path === 'permissionsPolicy') {
      return new _rxjs.BehaviorSubject({
        report_to: []
      });
    }
    throw new Error(`Unexpected config path: ${path}`);
  });
  return configService;
};
exports.createConfigService = createConfigService;
const createDefaultContext = () => {
  return {
    coreId,
    env,
    logger,
    configService: createConfigService()
  };
};
const createCoreContext = (overrides = {}) => ({
  ...createDefaultContext(),
  ...overrides
});

/**
 * Creates a concrete HttpService with a mocked context.
 */
exports.createCoreContext = createCoreContext;
const createHttpService = ({
  buildNum,
  ...overrides
} = {}) => {
  const ctx = createCoreContext(overrides);
  if (buildNum !== undefined) {
    ctx.env = {
      ...ctx.env,
      packageInfo: {
        ...ctx.env.packageInfo,
        buildNum
      }
    };
  }
  return new _coreHttpServerInternal.HttpService(ctx);
};
exports.createHttpService = createHttpService;