"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HttpRateLimiterService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @internal */

/** @internal */

/** @internal */

/** @internal */
class HttpRateLimiterService {
  constructor() {
    (0, _defineProperty2.default)(this, "overloaded$", new _rxjs.BehaviorSubject(false));
    (0, _defineProperty2.default)(this, "ready$", new _rxjs.Subject());
    (0, _defineProperty2.default)(this, "stopped$", new _rxjs.Subject());
    (0, _defineProperty2.default)(this, "handler", (request, response, toolkit) => {
      if (!this.shouldBeThrottled(request)) {
        return toolkit.next();
      }
      return response.customError({
        statusCode: 429,
        body: 'Server is overloaded'
      });
    });
  }
  shouldBeThrottled(request) {
    return !request.route.options.excludeFromRateLimiter && this.overloaded$.getValue();
  }
  watch(metrics$, {
    elu,
    term
  }) {
    metrics$.pipe((0, _rxjs.skipUntil)(this.ready$), (0, _rxjs.takeUntil)(this.stopped$), (0, _rxjs.map)(({
      short,
      medium,
      long
    }) => short >= elu && (term === 'short' || medium >= elu) && (term !== 'long' || long >= elu)), (0, _rxjs.endWith)(false)).subscribe(this.overloaded$);
  }
  setup({
    http,
    metrics
  }) {
    if (!http.rateLimiter.enabled) {
      return;
    }
    this.watch(metrics.getEluMetrics$(), http.rateLimiter);
    http.registerOnPreAuth(this.handler);
  }
  start() {
    this.ready$.next(true);
    this.ready$.complete();
  }
  stop() {
    this.stopped$.next(true);
    this.stopped$.complete();
  }
}
exports.HttpRateLimiterService = HttpRateLimiterService;