"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExecutionContextContainer = exports.BAGGAGE_MAX_PER_NAME_VALUE_PAIRS = void 0;
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// Switch to the standard Baggage header
// https://github.com/elastic/apm-agent-rum-js/issues/1040
const BAGGAGE_HEADER = 'x-kbn-context';

// Maximum number of bytes per a single name-value pair allowed by w3c spec
// https://w3c.github.io/baggage/
const BAGGAGE_MAX_PER_NAME_VALUE_PAIRS = exports.BAGGAGE_MAX_PER_NAME_VALUE_PAIRS = 4096;

// a single character can use up to 4 bytes
const MAX_BAGGAGE_LENGTH = BAGGAGE_MAX_PER_NAME_VALUE_PAIRS / 4;

// Limits the header value to max allowed "baggage" header property name-value pair
// It will help us switch to the "baggage" header when it becomes the standard.
// The trimmed value in the logs is better than nothing.
function enforceMaxLength(header) {
  return header.slice(0, MAX_BAGGAGE_LENGTH);
}

/**
 * @public
 */
var _context = /*#__PURE__*/new WeakMap();
class ExecutionContextContainer {
  constructor(context) {
    _classPrivateFieldInitSpec(this, _context, void 0);
    _classPrivateFieldSet(_context, this, context);
  }
  toString() {
    const value = JSON.stringify(_classPrivateFieldGet(_context, this));
    // escape content as the description property might contain non-ASCII symbols
    return enforceMaxLength(encodeURIComponent(value));
  }
  toHeader() {
    return {
      [BAGGAGE_HEADER]: this.toString()
    };
  }
  toJSON() {
    return _classPrivateFieldGet(_context, this);
  }
}
exports.ExecutionContextContainer = ExecutionContextContainer;