"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VersionHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const VersionHeader = ({
  version
}) => {
  const {
    build_hash: buildHash,
    build_number: buildNumber,
    number
  } = version;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "statusBuildVersion"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "core.statusPage.statusApp.statusActions.versionText",
    defaultMessage: "VERSION: {versionNum}",
    values: {
      versionNum: /*#__PURE__*/_react.default.createElement("strong", null, number)
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "statusBuildNumber"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "core.statusPage.statusApp.statusActions.buildText",
    defaultMessage: "BUILD: {buildNum}",
    values: {
      buildNum: /*#__PURE__*/_react.default.createElement("strong", null, buildNumber)
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "statusBuildHash"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "core.statusPage.statusApp.statusActions.commitText",
    defaultMessage: "COMMIT: {buildSha}",
    values: {
      buildSha: /*#__PURE__*/_react.default.createElement("strong", null, buildHash)
    }
  }))))));
};
exports.VersionHeader = VersionHeader;