"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UrlOverflowUi = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _url_overflow = require("./url_overflow");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const UrlOverflowUi = ({
  basePath
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "left"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "core.ui.errorUrlOverflow.optionsToFixErrorDescription",
    defaultMessage: "Things to try:"
  })), /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "core.ui.errorUrlOverflow.optionsToFixError.enableOptionText",
    defaultMessage: "Enable the {storeInSessionStorageConfig} option in {kibanaSettingsLink}.",
    values: {
      storeInSessionStorageConfig: /*#__PURE__*/_react.default.createElement("code", null, "state:storeInSessionStorage"),
      kibanaSettingsLink: /*#__PURE__*/_react.default.createElement("a", {
        href: basePath.prepend('/app/management/kibana/settings')
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "core.ui.errorUrlOverflow.optionsToFixError.enableOptionText.advancedSettingsLinkText",
        defaultMessage: "Advanced Settings"
      }))
    }
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "core.ui.errorUrlOverflow.optionsToFixError.removeStuffFromDashboardText",
    defaultMessage: "Simplify the object you are editing by removing content or filters."
  })), _url_overflow.IS_IE && /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "core.ui.errorUrlOverflow.optionsToFixError.doNotUseIEText",
    defaultMessage: "Upgrade to a modern browser. Every other supported browser we know of doesn't have this limit."
  }))));
};
exports.UrlOverflowUi = UrlOverflowUi;