"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.outdatedDocumentsSearchBulkIndex = void 0;
var Either = _interopRequireWildcard(require("fp-ts/lib/Either"));
var _constants = require("../../../common/constants");
var _helpers = require("../../../model/helpers");
var _actions = require("../../actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const outdatedDocumentsSearchBulkIndex = (state, res, context) => {
  if (Either.isLeft(res)) {
    if ((0, _actions.isTypeof)(res.left, 'request_entity_too_large_exception')) {
      return {
        ...state,
        controlState: 'FATAL',
        reason: _constants.FATAL_REASON_REQUEST_ENTITY_TOO_LARGE
      };
    } else if ((0, _actions.isTypeof)(res.left, 'target_index_had_write_block') || (0, _actions.isTypeof)(res.left, 'index_not_found_exception')) {
      // we fail on these errors since the target index will never get
      // deleted and should only have a write block if a newer version of
      // Kibana started an upgrade
      (0, _helpers.throwBadResponse)(state, res.left);
    } else {
      (0, _helpers.throwBadResponse)(state, res.left);
    }
  }
  if (state.currentBatch + 1 < state.bulkOperationBatches.length) {
    return {
      ...state,
      controlState: 'OUTDATED_DOCUMENTS_SEARCH_BULK_INDEX',
      currentBatch: state.currentBatch + 1
    };
  }
  return {
    ...state,
    controlState: 'OUTDATED_DOCUMENTS_SEARCH_READ',
    corruptDocumentIds: [],
    transformErrors: [],
    hasTransformedDocs: true
  };
};
exports.outdatedDocumentsSearchBulkIndex = outdatedDocumentsSearchBulkIndex;