"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPluginsBundlePaths = void 0;
var _filter_ui_plugins = require("../filter_ui_plugins");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getPluginsBundlePaths = ({
  uiPlugins,
  bundlesHref,
  isAnonymousPage
}) => {
  const pluginBundlePaths = new Map();
  const pluginsToProcess = (0, _filter_ui_plugins.filterUiPlugins)({
    uiPlugins,
    isAnonymousPage
  }).map(([id]) => id);
  while (pluginsToProcess.length > 0) {
    var _uiPlugins$internal$g, _uiPlugins$internal$g2;
    const pluginId = pluginsToProcess.pop();
    const plugin = uiPlugins.internal.get(pluginId);
    if (!plugin) {
      continue;
    }
    const {
      version
    } = plugin;
    pluginBundlePaths.set(pluginId, {
      publicPath: `${bundlesHref}/plugin/${pluginId}/${version}/`,
      bundlePath: `${bundlesHref}/plugin/${pluginId}/${version}/${pluginId}.plugin.js`
    });
    const pluginBundleIds = (_uiPlugins$internal$g = (_uiPlugins$internal$g2 = uiPlugins.internal.get(pluginId)) === null || _uiPlugins$internal$g2 === void 0 ? void 0 : _uiPlugins$internal$g2.requiredBundles) !== null && _uiPlugins$internal$g !== void 0 ? _uiPlugins$internal$g : [];
    pluginBundleIds.forEach(bundleId => {
      if (!pluginBundlePaths.has(bundleId)) {
        pluginsToProcess.push(bundleId);
      }
    });
  }
  return pluginBundlePaths;
};
exports.getPluginsBundlePaths = getPluginsBundlePaths;