"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.removeSurroundingSlashes = removeSurroundingSlashes;
exports.suffixPathnameToPathname = suffixPathnameToPathname;
exports.suffixPathnameToURLPathname = suffixPathnameToURLPathname;
var _nodeUrl = require("node:url");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function isEmptyPathname(pathname) {
  return !pathname || pathname === '/';
}
function removeTailSlashes(pathname) {
  let updated = pathname;
  while (updated.endsWith('/')) {
    updated = updated.substring(0, updated.length - 1);
  }
  return updated;
}
function removeLeadSlashes(pathname) {
  let updated = pathname;
  while (updated.startsWith('/')) {
    updated = updated.substring(1);
  }
  return updated;
}
function removeSurroundingSlashes(pathname) {
  return removeLeadSlashes(removeTailSlashes(pathname));
}
function suffixPathnameToURLPathname(urlString, pathname) {
  const url = new _nodeUrl.URL(urlString);
  url.pathname = suffixPathnameToPathname(url.pathname, pathname);
  return (0, _nodeUrl.format)(url);
}

/**
 * Appends a value to pathname. Pathname is assumed to come from URL.pathname
 * Also do some quality control on the path to ensure that it matches URL.pathname.
 */
function suffixPathnameToPathname(pathnameA, pathnameB) {
  if (isEmptyPathname(pathnameA)) {
    return `/${removeSurroundingSlashes(pathnameB)}`;
  }
  if (isEmptyPathname(pathnameB)) {
    return `/${removeSurroundingSlashes(pathnameA)}`;
  }
  return `/${removeSurroundingSlashes(pathnameA)}/${removeSurroundingSlashes(pathnameB)}`;
}