"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomBrandingService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * @internal
 */

class CustomBrandingService {
  constructor(coreContext) {
    (0, _defineProperty2.default)(this, "pluginName", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "fetchFn", void 0);
    (0, _defineProperty2.default)(this, "startCalled", false);
    (0, _defineProperty2.default)(this, "getBrandingFor", async (request, options) => {
      if (!this.startCalled) {
        throw new Error('Cannot be called before #start');
      }
      if (!this.pluginName || this.pluginName !== 'customBranding' || !this.fetchFn) {
        return {};
      }
      return this.fetchFn(request, Boolean(options === null || options === void 0 ? void 0 : options.unauthenticated));
    });
    this.logger = coreContext.logger.get('custom-branding-service');
  }
  setup() {
    return {
      register: (pluginName, fetchFn) => {
        this.logger.info('CustomBrandingService registering plugin: ' + pluginName);
        if (this.pluginName) {
          throw new Error('Another plugin already registered');
        }
        if (!pluginName || !fetchFn) {
          throw new Error('Both plugin name and fetch function need to be provided when registering a plugin');
        }
        this.pluginName = pluginName;
        this.fetchFn = fetchFn;
      },
      getBrandingFor: this.getBrandingFor
    };
  }
  start() {
    this.startCalled = true;
    return {};
  }
  stop() {}
}
exports.CustomBrandingService = CustomBrandingService;