"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getESQLControlFactory = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _esqlVariablesTypes = require("@kbn/esql-variables-types");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _presentationContainers = require("@kbn/presentation-containers");
var _common = require("../../../common");
var _kibana_services = require("../../services/kibana_services");
var _initialize_default_control_api = require("../initialize_default_control_api");
var _esql_control_selections = require("./esql_control_selections");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const displayName = _i18n.i18n.translate('controls.esqlValuesControl.displayName', {
  defaultMessage: 'Static values list'
});
const getESQLControlFactory = () => {
  return {
    type: _common.ESQL_CONTROL,
    order: 3,
    getIconType: () => 'editorChecklist',
    getDisplayName: () => displayName,
    buildControl: async (initialState, buildApi, uuid, controlGroupApi) => {
      const defaultControl = (0, _initialize_default_control_api.initializeDefaultControlApi)(initialState);
      const selections = (0, _esql_control_selections.initializeESQLControlSelections)(initialState);
      const closeOverlay = () => {
        if ((0, _presentationPublishing.apiHasParentApi)(controlGroupApi) && (0, _presentationContainers.tracksOverlays)(controlGroupApi.parentApi)) {
          controlGroupApi.parentApi.clearOverlays();
        }
      };
      const onSaveControl = updatedState => {
        controlGroupApi === null || controlGroupApi === void 0 ? void 0 : controlGroupApi.replacePanel(uuid, {
          panelType: 'esqlControl',
          initialState: updatedState
        });
        closeOverlay();
      };
      const api = buildApi({
        ...defaultControl.api,
        ...selections.api,
        defaultTitle$: new _rxjs.BehaviorSubject(initialState.title),
        isEditingEnabled: () => true,
        getTypeDisplayName: () => displayName,
        onEdit: async () => {
          const state = {
            ...initialState,
            ...defaultControl.serialize().rawState
          };
          const variablesInParent = (0, _esqlVariablesTypes.apiPublishesESQLVariables)(api.parentApi) ? api.parentApi.esqlVariables$.value : [];
          try {
            await _kibana_services.uiActionsService.getTrigger('ESQL_CONTROL_TRIGGER').exec({
              queryString: initialState.esqlQuery,
              variableType: initialState.variableType,
              controlType: initialState.controlType,
              esqlVariables: variablesInParent,
              onSaveControl,
              onCancelControl: closeOverlay,
              initialState: state
            });
          } catch (e) {
            // eslint-disable-next-line no-console
            console.error('Error getting ESQL control trigger', e);
          }
        },
        serializeState: () => {
          const {
            rawState: defaultControlState
          } = defaultControl.serialize();
          return {
            rawState: {
              ...defaultControlState,
              selectedOptions: selections.selectedOptions$.getValue(),
              availableOptions: selections.availableOptions$.getValue(),
              variableName: selections.variableName$.getValue(),
              variableType: selections.variableType$.getValue(),
              controlType: selections.controlType$.getValue(),
              esqlQuery: selections.esqlQuery$.getValue(),
              title: selections.title$.getValue()
            },
            references: []
          };
        },
        clearSelections: () => {
          // do nothing, not allowed for now;
        }
      }, {
        ...defaultControl.comparators,
        ...selections.comparators
      });
      const inputCss = (0, _react2.css)`
        .euiComboBox__inputWrap {
          box-shadow: none;
        }
      `;
      return {
        api,
        Component: ({
          className: controlPanelClassName
        }) => {
          const [availableOptions, selectedOptions] = (0, _presentationPublishing.useBatchedPublishingSubjects)(selections.availableOptions$, selections.selectedOptions$);
          return /*#__PURE__*/_react.default.createElement("div", {
            className: controlPanelClassName
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
            "aria-label": _i18n.i18n.translate('controls.controlGroup.manageControl.esql.ariaLabel', {
              defaultMessage: 'ES|QL variable control'
            }),
            placeholder: _i18n.i18n.translate('controls.controlGroup.manageControl.esql.placeholder', {
              defaultMessage: 'Select a single value'
            }),
            inputPopoverProps: {
              css: inputCss,
              className: 'esqlControlValuesCombobox'
            },
            "data-test-subj": "esqlControlValuesDropdown",
            singleSelection: {
              asPlainText: true
            },
            options: availableOptions.map(option => ({
              label: option
            })),
            selectedOptions: selectedOptions.map(option => ({
              label: option
            })),
            compressed: true,
            fullWidth: true,
            isClearable: false,
            onChange: options => {
              const selectedValues = options.map(option => option.label);
              selections.setSelectedOptions(selectedValues);
            }
          }));
        }
      };
    }
  };
};
exports.getESQLControlFactory = getESQLControlFactory;