"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeESQLControlSelections = initializeESQLControlSelections;
var _reactFastCompare = _interopRequireDefault(require("react-fast-compare"));
var _rxjs = require("rxjs");
var _esqlValidationAutocomplete = require("@kbn/esql-validation-autocomplete");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function initializeESQLControlSelections(initialState) {
  var _initialState$availab, _initialState$selecte, _initialState$variabl, _initialState$variabl2, _initialState$control, _initialState$esqlQue, _initialState$selecte2;
  const availableOptions$ = new _rxjs.BehaviorSubject((_initialState$availab = initialState.availableOptions) !== null && _initialState$availab !== void 0 ? _initialState$availab : []);
  const selectedOptions$ = new _rxjs.BehaviorSubject((_initialState$selecte = initialState.selectedOptions) !== null && _initialState$selecte !== void 0 ? _initialState$selecte : []);
  const hasSelections$ = new _rxjs.BehaviorSubject(false); // hardcoded to false to prevent clear action from appearing.
  const variableName$ = new _rxjs.BehaviorSubject((_initialState$variabl = initialState.variableName) !== null && _initialState$variabl !== void 0 ? _initialState$variabl : '');
  const variableType$ = new _rxjs.BehaviorSubject((_initialState$variabl2 = initialState.variableType) !== null && _initialState$variabl2 !== void 0 ? _initialState$variabl2 : _esqlValidationAutocomplete.ESQLVariableType.VALUES);
  const controlType$ = new _rxjs.BehaviorSubject((_initialState$control = initialState.controlType) !== null && _initialState$control !== void 0 ? _initialState$control : '');
  const esqlQuery$ = new _rxjs.BehaviorSubject((_initialState$esqlQue = initialState.esqlQuery) !== null && _initialState$esqlQue !== void 0 ? _initialState$esqlQue : '');
  const title$ = new _rxjs.BehaviorSubject(initialState.title);
  const selectedOptionsComparatorFunction = (a, b) => (0, _reactFastCompare.default)(a !== null && a !== void 0 ? a : [], b !== null && b !== void 0 ? b : []);
  function setSelectedOptions(next) {
    if (!selectedOptionsComparatorFunction(selectedOptions$.value, next)) {
      selectedOptions$.next(next);
    }
  }

  // derive ESQL control variable from state.
  const getEsqlVariable = () => ({
    key: variableName$.value,
    value: isNaN(Number(selectedOptions$.value[0])) ? selectedOptions$.value[0] : Number(selectedOptions$.value[0]),
    type: variableType$.value
  });
  const esqlVariable$ = new _rxjs.BehaviorSubject(getEsqlVariable());
  const subscriptions = (0, _rxjs.combineLatest)([variableName$, variableType$, selectedOptions$]).subscribe(() => esqlVariable$.next(getEsqlVariable()));
  return {
    cleanup: () => subscriptions.unsubscribe(),
    api: {
      hasSelections$: hasSelections$,
      esqlVariable$: esqlVariable$
    },
    comparators: {
      selectedOptions: [selectedOptions$, setSelectedOptions, selectedOptionsComparatorFunction],
      availableOptions: [availableOptions$, next => availableOptions$.next(next)],
      variableName: [variableName$, next => variableName$.next(next)],
      variableType: [variableType$, next => variableType$.next(next)],
      controlType: [controlType$, next => controlType$.next(next)],
      esqlQuery: [esqlQuery$, next => esqlQuery$.next(next)],
      title: [title$, next => title$.next(next)]
    },
    hasInitialSelections: (_initialState$selecte2 = initialState.selectedOptions) === null || _initialState$selecte2 === void 0 ? void 0 : _initialState$selecte2.length,
    selectedOptions$: selectedOptions$,
    availableOptions$: availableOptions$,
    variableName$: variableName$,
    variableType$: variableType$,
    controlType$: controlType$,
    esqlQuery$: esqlQuery$,
    title$: title$,
    setSelectedOptions
  };
}