"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.apiPublishesAsyncFilters = void 0;
var _presentationPublishing = require("@kbn/presentation-publishing");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Data control filter generation is async because
 * 1) filter generation requires a DataView
 * 2) filter generation is a subscription
 */

const apiPublishesAsyncFilters = unknownApi => {
  return Boolean(unknownApi && (0, _presentationPublishing.apiPublishesFilters)(unknownApi) && (unknownApi === null || unknownApi === void 0 ? void 0 : unknownApi.untilFiltersReady) !== undefined);
};
exports.apiPublishesAsyncFilters = apiPublishesAsyncFilters;